/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.entity.passive.EntityToad;

public class PoisonToadBrewEffect
extends BrewActionEffect {
    public PoisonToadBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        if (!(targetEntity instanceof EntityToad) && modifiers.powerScalingFactor == 1.0 || world.rand.nextDouble() < modifiers.powerScalingFactor * 0.2) {
            EntityToad toad2 = new EntityToad(world);
            toad2.setLocationAndAngles(targetEntity.posX, targetEntity.posY + (double)targetEntity.height + 1.0, targetEntity.posZ, 0.0f, 0.0f);
            toad2.setTimeToLive(60 + modifiers.getStrength() * 40, true);
            world.spawnEntity((Entity)toad2);
        }
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack stack) {
        EntityToad toad2 = new EntityToad(world);
        toad2.setLocationAndAngles(0.5 + (double)pos.getX(), 2.5 + (double)pos.getY(), 0.5 + (double)pos.getZ(), 0.0f, 0.0f);
        toad2.setTimeToLive(60 + modifiers.getStrength() * 40, true);
        world.spawnEntity((Entity)toad2);
    }
}

