/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.BlockActionCircle;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class LevellingBrewEffect
extends BrewActionEffect {
    public LevellingBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int r, final ModifiersEffect modifiers, ItemStack actionStack) {
        BlockPos p = modifiers.ritualised ? pos.down() : pos;
        int radius = modifiers.ritualised ? r + (modifiers.getStrength() + 1) * 3 : r;
        final AtomicInteger dirt = new AtomicInteger();
        final AtomicInteger stone = new AtomicInteger();
        final AtomicInteger sand = new AtomicInteger();
        final AtomicInteger sandstone = new AtomicInteger();
        final AtomicInteger netherrack = new AtomicInteger();
        final AtomicInteger endstone = new AtomicInteger();
        final int s = modifiers.getStrength();
        int defaultAmount = modifiers.ritualised ? 64 + 32 * modifiers.getStrength() : 16;
        Block hitBlock = world.getBlockState(p).getBlock();
        if (hitBlock == Blocks.DIRT) {
            dirt.addAndGet(defaultAmount);
        } else if (hitBlock == Blocks.STONE) {
            stone.addAndGet(defaultAmount);
        } else if (hitBlock == Blocks.SAND) {
            sand.addAndGet(defaultAmount);
        } else if (hitBlock == Blocks.SANDSTONE) {
            sandstone.addAndGet(defaultAmount);
        } else if (hitBlock == Blocks.NETHERRACK) {
            netherrack.addAndGet(defaultAmount);
        } else if (hitBlock == Blocks.END_STONE) {
            endstone.addAndGet(defaultAmount);
        }
        new BlockActionCircle(){

            @Override
            public void onBlock(World world, BlockPos p) {
                for (BlockPos pos : BlockPos.getAllInBox((BlockPos)p.up(), (BlockPos)p.up(s + 4))) {
                    IBlockState state = world.getBlockState(pos);
                    Block block = state.getBlock();
                    if (block == Blocks.AIR || !WitcheryUtils.isBlockBreakable(world, pos, state) || !WitcheryUtils.canBreak(state)) continue;
                    if (block == Blocks.STONE) {
                        stone.incrementAndGet();
                    } else if (block == Blocks.SAND) {
                        sand.incrementAndGet();
                    } else if (block == Blocks.SANDSTONE) {
                        sandstone.incrementAndGet();
                    } else if (block == Blocks.NETHERRACK) {
                        netherrack.incrementAndGet();
                    } else if (block == Blocks.END_STONE) {
                        endstone.incrementAndGet();
                    } else {
                        dirt.incrementAndGet();
                    }
                    world.setBlockToAir(pos);
                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.5f, 0.5f, EnumParticleTypes.SMOKE_NORMAL), world, pos);
                }
            }
        }.processFilledCircle(world, p, radius);
        for (final BlockPos n : BlockPos.getAllInBox((BlockPos)p.down(4 + s), (BlockPos)p)) {
            new BlockActionCircle(){

                @Override
                public void onBlock(World world, BlockPos pos) {
                    if (BlockUtil.isReplaceableBlock(world, n, (EntityLivingBase)modifiers.caster)) {
                        if (endstone.get() > 0) {
                            endstone.decrementAndGet();
                            world.setBlockState(n, Blocks.END_STONE.getDefaultState());
                        } else if (netherrack.get() > 0) {
                            netherrack.decrementAndGet();
                            world.setBlockState(n, Blocks.NETHERRACK.getDefaultState());
                        } else if (sandstone.get() > 0) {
                            sandstone.decrementAndGet();
                            world.setBlockState(n, Blocks.SANDSTONE.getDefaultState());
                        } else if (sand.get() > 0) {
                            sand.decrementAndGet();
                            world.setBlockState(n, Blocks.SAND.getDefaultState());
                        } else if (stone.get() > 0) {
                            stone.decrementAndGet();
                            world.setBlockState(n, Blocks.STONE.getDefaultState());
                        } else {
                            if (dirt.get() <= 0) {
                                return;
                            }
                            dirt.decrementAndGet();
                            world.setBlockState(pos, Blocks.DIRT.getDefaultState());
                        }
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)n.getX(), (double)n.getY(), (double)n.getZ(), 0.5f, 0.5f, EnumParticleTypes.SMOKE_NORMAL), world, n, 16.0);
                    }
                }
            }.processFilledCircle(world, p, radius);
        }
        world.playSound(null, pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, modifiers.caster.getSoundCategory(), 1.0f, 2.0f);
    }
}

