/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.util.EntityUtil;

public class KnockbackBrewEffect
extends BrewActionEffect {
    public KnockbackBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        if (modifiers.impactLocation != null) {
            EntityUtil.pushback((Entity)targetEntity, modifiers.impactLocation, 1.0 + (double)modifiers.getStrength() * modifiers.powerScalingFactor, 0.5 + (double)modifiers.getStrength() * 0.2);
        } else {
            double radius = 3 + modifiers.getStrength();
            double radiusSq = radius * radius;
            Vec3d position = targetEntity.getPositionVector();
            List entities = world.getEntitiesWithinAABBExcludingEntity((Entity)targetEntity, new AxisAlignedBB(position.add(-radius, -radius, -radius), position.add(radius, radius, radius)));
            for (Entity entity : entities) {
                if (!(entity instanceof EntityLivingBase) && !(entity instanceof EntityItem) || !(targetEntity.getDistanceSq(entity) <= radiusSq)) continue;
                EntityUtil.pushback(entity, position, 1.0 + (double)modifiers.getStrength() * modifiers.powerScalingFactor, 0.5 + (double)modifiers.getStrength() * 0.2);
            }
        }
    }
}

