/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.brewing.action.effect.PotionBrewEffect;
import net.msrandom.witchery.entity.EntityDemon;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.util.WitcheryUtils;

public class InfernoBrewEffect
extends BrewActionEffect {
    public InfernoBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    public boolean isRitualTargetLocationValid(MinecraftServer server, World world, BlockPos pos, BlockPos target, int dimension, ModifiersRitual modifiers) {
        return WitcheryUtils.isCircleGlyph((IBlockAccess)server.getWorld(dimension), target, 3, WitcheryBlocks.GLYPH_INFERNAL);
    }

    @Override
    protected void doApplyRitualToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersRitual ritualModifiers, ModifiersEffect modifiers, ItemStack stack) {
        Infusion.spawnCreature(world, EntityDemon.class, pos, null, 0, 2, EnumParticleTypes.FLAME, SoundEvents.ENTITY_ENDERDRAGON_GROWL);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        PotionBrewEffect.applyPotionEffect(targetEntity, modifiers, WitcheryPotionEffects.NETHER_BOUND, 3600, modifiers.noParticles, modifiers.caster);
    }
}

