/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockStockade;
import net.msrandom.witchery.block.WitcheryBlockLeaves;
import net.msrandom.witchery.block.WitcheryBlockLog;
import net.msrandom.witchery.block.WitcheryBlockPlanks;
import net.msrandom.witchery.block.WitcheryWoodSlab;
import net.msrandom.witchery.block.WitcheryWoodStairs;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.BlockActionSphere;
import net.msrandom.witchery.util.WitcheryUtils;

public class IceWorldBrewEffect
extends BrewActionEffect {
    public IceWorldBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack actionStack) {
        if (!world.isRemote) {
            int ceil = (int)Math.ceil(Math.max((double)radius * 1.5, 1.0));
            new BlockActionSphere(){

                @Override
                public void onBlock(World world, BlockPos pos) {
                    IBlockState state = world.getBlockState(pos);
                    if (WitcheryUtils.isBlockBreakable(world, pos, state) && WitcheryUtils.canBreak(state)) {
                        if (state.getBlock() != Blocks.OAK_DOOR) {
                            return;
                        }
                        if (state.getValue((IProperty)BlockDoor.HALF) == BlockDoor.EnumDoorHalf.UPPER) {
                            pos = pos.down();
                        }
                        world.setBlockToAir(pos);
                        world.setBlockToAir(pos.up());
                        ItemDoor.placeDoor((World)world, (BlockPos)pos, (EnumFacing)((EnumFacing)state.getValue((IProperty)BlockDoor.FACING)), (Block)WitcheryBlocks.PERPETUAL_ICE_DOOR, (boolean)false);
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 0.25f, 0.25f, EnumParticleTypes.SMOKE_NORMAL), world, pos.up());
                    }
                }
            }.drawFilledSphere(world, pos, ceil);
            new BlockActionSphere(){

                @Override
                public void onBlock(World world, BlockPos pos) {
                    IBlockState state = world.getBlockState(pos);
                    Block block = state.getBlock();
                    if (WitcheryUtils.isBlockBreakable(world, pos, state) && WitcheryUtils.canBreak(state)) {
                        if (block == Blocks.DIRT || block == Blocks.GRASS || block == Blocks.MYCELIUM || block == Blocks.SAND) {
                            world.setBlockState(pos, Blocks.SNOW.getDefaultState());
                        } else if (block == Blocks.COBBLESTONE || block == Blocks.MOSSY_COBBLESTONE || block == Blocks.LOG || block == Blocks.LOG2 || block instanceof WitcheryBlockLog) {
                            world.setBlockState(pos, Blocks.PACKED_ICE.getDefaultState());
                        } else if (block == Blocks.STONE || block == Blocks.STONEBRICK || block == Blocks.BRICK_BLOCK || block == Blocks.PLANKS || block == Blocks.LEAVES || block == Blocks.LEAVES2 || block instanceof WitcheryBlockLeaves || block instanceof WitcheryBlockPlanks || block == Blocks.SANDSTONE) {
                            world.setBlockState(pos, WitcheryBlocks.PERPETUAL_ICE.getDefaultState());
                        } else if (block == Blocks.STONE_PRESSURE_PLATE || block == Blocks.WOODEN_PRESSURE_PLATE) {
                            world.setBlockState(pos, WitcheryBlocks.PERPETUAL_ICE_PRESSURE_PLATE.getDefaultState());
                        } else if (block == Blocks.STONE_STAIRS || block == Blocks.BRICK_STAIRS || block == Blocks.STONE_BRICK_STAIRS || block == Blocks.OAK_STAIRS || block == Blocks.SPRUCE_STAIRS || block == Blocks.SANDSTONE_STAIRS || block == Blocks.BIRCH_STAIRS || block == Blocks.JUNGLE_STAIRS || block == Blocks.DARK_OAK_STAIRS || block == Blocks.ACACIA_STAIRS || block instanceof WitcheryWoodStairs) {
                            world.setBlockState(pos, WitcheryBlocks.PERPETUAL_ICE_STAIRS.getDefaultState(), 3);
                        } else if (block == Blocks.STONE_SLAB || block == Blocks.WOODEN_SLAB || block instanceof WitcheryWoodSlab && !((WitcheryWoodSlab)block).isDouble()) {
                            world.setBlockState(pos, WitcheryBlocks.PERPETUAL_ICE_SLAB.getDefaultState());
                        } else if (block == Blocks.DOUBLE_STONE_SLAB || block == Blocks.DOUBLE_WOODEN_SLAB || block instanceof WitcheryWoodSlab && ((WitcheryWoodSlab)block).isDouble()) {
                            world.setBlockState(pos, WitcheryBlocks.PERPETUAL_ICE_SLAB_DOUBLE.getDefaultState());
                        } else if (block instanceof BlockFence || block == Blocks.COBBLESTONE_WALL) {
                            world.setBlockState(pos, WitcheryBlocks.PERPETUAL_ICE_FENCE.getDefaultState());
                        } else if (block instanceof BlockFenceGate) {
                            world.setBlockState(pos, WitcheryBlocks.PERPETUAL_ICE_FENCE_GATE.getDefaultState());
                        } else {
                            if (!(block instanceof BlockStockade)) {
                                return;
                            }
                            world.setBlockState(pos, WitcheryBlocks.ICE_STOCKADE.getDefaultState());
                        }
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 0.25f, 0.25f, EnumParticleTypes.SMOKE_NORMAL), world, pos.up());
                    }
                }
            }.drawFilledSphere(world, pos, ceil);
            world.playSound(null, pos, SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, modifiers.caster.getSoundCategory(), 0.5f, 2.0f);
        }
    }
}

