/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionBlockCircle;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;

public class HarvestingBrewEffect
extends BrewActionBlockCircle {
    public HarvestingBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void onCircleBlock(World world, BlockPos p, ModifiersEffect modifiers, AtomicInteger counter) {
        for (BlockPos pos : BlockPos.getAllInBox((BlockPos)p.down(1), (BlockPos)p.up(1))) {
            IBlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            if (!(block instanceof BlockBush)) continue;
            NonNullList drops = NonNullList.create();
            block.getDrops(drops, (IBlockAccess)world, pos, state, Math.max(modifiers.getStrength() - 1, 0));
            world.setBlockToAir(pos);
            counter.incrementAndGet();
            if (world.rand.nextInt(counter.get()) == 0) {
                world.playEvent(2001, pos, Block.getStateId((IBlockState)state));
            }
            for (ItemStack drop : drops) {
                world.spawnEntity((Entity)new EntityItem(world, 0.5 + (double)pos.getX(), 0.5 + (double)pos.getY(), 0.5 + (double)pos.getZ(), drop.copy()));
            }
        }
    }
}

