/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.util.EntityUtil;

public class FrogsTongueBrewEffect
extends BrewActionEffect {
    public FrogsTongueBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        if (modifiers.getStrength() > 0 && !(modifiers.caster instanceof FakePlayer)) {
            EntityUtil.pullTowards((Entity)targetEntity, modifiers.caster.getPositionVector(), 0.05, 0.0);
        } else {
            EntityUtil.pullTowards((Entity)targetEntity, modifiers.impactLocation, 0.05, 0.0);
        }
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack stack) {
        double R_SQ = (double)radius * (double)radius;
        Vec3d position = modifiers.impactLocation;
        AxisAlignedBB bb = new AxisAlignedBB(position.x - (double)radius, position.y - (double)radius, position.z - (double)radius, position.x + (double)radius, position.y + (double)radius, position.z + (double)radius);
        List list1 = world.getEntitiesWithinAABB(Entity.class, bb);
        for (Entity targetEntity : list1) {
            double distanceSq;
            if (targetEntity instanceof EntityLivingBase || (distanceSq = targetEntity.getDistanceSq(position.x, position.y, position.z)) > R_SQ) continue;
            if (modifiers.getStrength() > 0 && !(modifiers.caster instanceof FakePlayer)) {
                EntityUtil.pullTowards(targetEntity, modifiers.caster.getPositionVector(), 0.05, 0.0);
                continue;
            }
            EntityUtil.pullTowards(targetEntity, modifiers.impactLocation, 0.05, 0.0);
        }
    }
}

