/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.entity.EntitySplatter;

public class FlamesBrewEffect
extends BrewActionEffect {
    public FlamesBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack stack) {
        if (!world.isRemote && !modifiers.isGlancing) {
            EntitySplatter.splatter(world, pos.offset(side), modifiers.getStrength());
        }
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        if (!world.isRemote && !modifiers.isGlancing && targetEntity != null) {
            BlockPos coord = targetEntity.getPosition();
            targetEntity.setFire(2 + 2 * modifiers.getStrength());
            if (modifiers.powerScalingFactor == 1.0) {
                EntitySplatter.splatter(world, coord, modifiers.getStrength());
            }
        }
    }
}

