/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.util.BlockActionCircle;
import net.msrandom.witchery.util.WitcheryUtils;

public class ExtinguishBrewEffect
extends BrewActionEffect {
    public ExtinguishBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        if (modifiers.getStrength() > 1 || !world.provider.isNether()) {
            if (modifiers.getStrength() > 0 && targetEntity instanceof EntityBlaze) {
                targetEntity.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)modifiers.caster, (Entity)modifiers.caster), (float)(modifiers.getStrength() + 1) * 4.0f);
            }
            if (targetEntity.isBurning()) {
                targetEntity.extinguish();
            }
        }
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, final int radius, final ModifiersEffect modifiers, ItemStack stack) {
        if (modifiers.getStrength() > 1 || !world.provider.isNether()) {
            new BlockActionCircle(){

                @Override
                public void onBlock(World world, BlockPos p) {
                    for (BlockPos pos : BlockPos.getAllInBox((BlockPos)p.down(radius), (BlockPos)p.up(radius))) {
                        IBlockState state = world.getBlockState(pos);
                        if (state.getBlock() != Blocks.FIRE || !WitcheryUtils.isBlockBreakable(world, pos, state) || !WitcheryUtils.canBreak(state)) continue;
                        world.setBlockToAir(pos);
                        world.playSound(null, pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, modifiers.caster.getSoundCategory(), 1.0f, 2.0f);
                    }
                }
            }.processFilledCircle(world, pos, radius + (modifiers.ritualised ? 5 : 0));
        }
    }
}

