/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.BlockActionCircle;
import net.msrandom.witchery.util.WitcheryUtils;

public class ErosionBrewEffect
extends BrewActionEffect {
    public ErosionBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack actionStack) {
        final AtomicInteger obsidianCount = new AtomicInteger();
        for (int r = radius; r > 0; --r) {
            new BlockActionCircle(){

                @Override
                public void onBlock(World world, BlockPos pos) {
                    IBlockState state = world.getBlockState(pos);
                    if (WitcheryUtils.isBlockBreakable(world, pos, state) && WitcheryUtils.canBreak(state)) {
                        world.setBlockToAir(pos);
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.5f, 0.5f, EnumParticleTypes.WATER_SPLASH), world, pos);
                        obsidianCount.addAndGet(state.getBlock() == Blocks.OBSIDIAN ? 1 : 0);
                    }
                }
            }.processFilledCircle(world, pos, r);
        }
        world.playSound(null, pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, modifiers.caster.getSoundCategory(), 1.0f, 2.0f);
        world.spawnEntity((Entity)new EntityItem(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack(Blocks.OBSIDIAN, obsidianCount.get())));
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        if (world.rand.nextInt(MathHelper.ceil((double)(5.0 / modifiers.powerScalingFactor))) == 0) {
            targetEntity.attackEntityFrom(DamageSource.causeThrownDamage((Entity)targetEntity, (Entity)modifiers.caster), (float)MathHelper.ceil((double)(8.0 * modifiers.powerScalingFactor)));
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack = targetEntity.getItemStackFromSlot(slot);
            if (stack.isEmpty() || !stack.isItemStackDamageable()) continue;
            stack.damageItem(MathHelper.ceil((double)((50.0 + (double)world.rand.nextInt(25)) * modifiers.powerScalingFactor)), (EntityLivingBase)modifiers.caster);
        }
    }
}

