/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.entity.EntitySummonedUndead;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.util.BlockActionCircle;
import net.msrandom.witchery.util.WitcheryUtils;

public class DissipateBrewEffect
extends BrewActionEffect {
    public DissipateBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        if (targetEntity instanceof EntitySummonedUndead) {
            targetEntity.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)modifiers.caster, (Entity)modifiers.caster), (float)(modifiers.getStrength() + 1) * 5.0f);
        }
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, final int radius, final ModifiersEffect modifiers, ItemStack stack) {
        new BlockActionCircle(){

            @Override
            public void onBlock(World world, BlockPos p) {
                for (BlockPos pos : BlockPos.getAllInBox((BlockPos)p.down(radius), (BlockPos)p.up(radius))) {
                    IFluidBlock fluidBlock;
                    IBlockState state = world.getBlockState(pos);
                    if (state.getBlock() == WitcheryBlocks.BREW_GAS) {
                        if (!WitcheryUtils.isBlockBreakable(world, pos, state) || !WitcheryUtils.canBreak(state)) continue;
                        world.setBlockToAir(pos);
                        world.playSound(null, pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, modifiers.caster.getSoundCategory(), 1.0f, 2.0f);
                        continue;
                    }
                    if (!(state instanceof IFluidBlock) || modifiers.getStrength() < 1 || (fluidBlock = (IFluidBlock)state).getFluid() == null || !fluidBlock.getFluid().isGaseous() || !WitcheryUtils.isBlockBreakable(world, pos, state) || !WitcheryUtils.canBreak(state)) continue;
                    world.setBlockToAir(pos);
                    world.playSound(null, pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, modifiers.caster.getSoundCategory(), 1.0f, 2.0f);
                }
            }
        }.processFilledCircle(world, pos, radius);
    }
}

