/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.brewing.action.effect.PotionBrewEffect;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0017B1\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lnet/msrandom/witchery/brewing/action/effect/CurseBrewEffect;", "Lnet/msrandom/witchery/brewing/action/effect/PotionBrewEffect;", "serializer", "Lnet/msrandom/witchery/brewing/action/effect/BrewEffectSerializer;", "potion", "Lnet/minecraft/potion/Potion;", "baseDuration", "", "invertedPotion", "invertedDuration", "(Lnet/msrandom/witchery/brewing/action/effect/BrewEffectSerializer;Lnet/minecraft/potion/Potion;ILnet/minecraft/potion/Potion;I)V", "applyRitualToEntity", "", "world", "Lnet/minecraft/world/World;", "victim", "Lnet/minecraft/entity/EntityLivingBase;", "ritualModifiers", "Lnet/msrandom/witchery/brewing/ModifiersRitual;", "modifiers", "Lnet/msrandom/witchery/brewing/ModifiersEffect;", "stack", "Lnet/minecraft/item/ItemStack;", "Serializer", "WitcheryResurrected"})
public class CurseBrewEffect
extends PotionBrewEffect {
    @Override
    public void applyRitualToEntity(@NotNull World world, @NotNull EntityLivingBase victim, @NotNull ModifiersRitual ritualModifiers, @NotNull ModifiersEffect modifiers, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)victim, (String)"victim");
        Intrinsics.checkParameterIsNotNull((Object)ritualModifiers, (String)"ritualModifiers");
        Intrinsics.checkParameterIsNotNull((Object)modifiers, (String)"modifiers");
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        int oldDuration = modifiers.duration.getValue();
        boolean oldNoParticles = modifiers.noParticles;
        if (ritualModifiers.taglockUsed && (this.getPotion() == this.getInvertedPotion() || modifiers.inverted)) {
            modifiers.duration.setValue(10000);
            modifiers.noParticles = true;
        }
        this.applyToEntity(world, victim, modifiers, stack);
        modifiers.duration.setValue(oldDuration);
        modifiers.noParticles = oldNoParticles;
    }

    public CurseBrewEffect(@NotNull BrewEffectSerializer<?> serializer, @NotNull Potion potion, int baseDuration, @NotNull Potion invertedPotion, int invertedDuration) {
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        Intrinsics.checkParameterIsNotNull((Object)potion, (String)"potion");
        Intrinsics.checkParameterIsNotNull((Object)invertedPotion, (String)"invertedPotion");
        super(serializer, potion, baseDuration, invertedPotion, invertedDuration, 10);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lnet/msrandom/witchery/brewing/action/effect/CurseBrewEffect$Serializer;", "Lnet/msrandom/witchery/brewing/action/effect/BrewEffectSerializer;", "Lnet/msrandom/witchery/brewing/action/effect/CurseBrewEffect;", "()V", "read", "json", "Lcom/google/gson/JsonObject;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "write", "", "effect", "WitcheryResurrected"})
    public static final class Serializer
    implements BrewEffectSerializer<CurseBrewEffect> {
        public static final Serializer INSTANCE;

        @Override
        @NotNull
        public CurseBrewEffect read(@NotNull JsonObject json) {
            JsonElement jsonElement;
            int n;
            Potion potion;
            BrewEffectSerializer brewEffectSerializer;
            int duration;
            block6: {
                Potion potion2;
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
                    JsonElement jsonElement2 = json.get("potion");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"json[\"potion\"]");
                    Potion potion3 = Potion.getPotionFromResourceLocation((String)jsonElement2.getAsString());
                    if (potion3 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)potion3, (String)"Potion.getPotionFromReso\u2026son[\"potion\"].asString)!!");
                    potion2 = potion3;
                    JsonElement jsonElement3 = json.get("duration");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"json[\"duration\"]");
                    duration = jsonElement3.getAsInt();
                    brewEffectSerializer = this;
                    potion = potion2;
                    n = duration;
                    jsonElement = json.get("inverted_potion");
                    if (jsonElement == null) break block5;
                    JsonElement jsonElement4 = jsonElement;
                    int n2 = n;
                    Potion potion4 = potion;
                    BrewEffectSerializer brewEffectSerializer2 = brewEffectSerializer;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsonElement it = jsonElement4;
                    boolean bl3 = false;
                    Potion potion5 = Potion.getPotionFromResourceLocation((String)it.getAsString());
                    if (potion5 == null) {
                        Intrinsics.throwNpe();
                    }
                    Potion potion6 = potion5;
                    brewEffectSerializer = brewEffectSerializer2;
                    potion = potion4;
                    n = n2;
                    jsonElement = potion6;
                    if (jsonElement != null) break block6;
                }
                jsonElement = potion2;
            }
            JsonElement jsonElement5 = json.get("inverted_duration");
            int n3 = jsonElement5 != null ? jsonElement5.getAsInt() : duration;
            JsonElement jsonElement6 = jsonElement;
            int n4 = n;
            Potion potion7 = potion;
            BrewEffectSerializer brewEffectSerializer3 = brewEffectSerializer;
            return new CurseBrewEffect(brewEffectSerializer3, potion7, n4, (Potion)jsonElement6, n3);
        }

        @Override
        @NotNull
        public CurseBrewEffect read(@NotNull PacketBuffer buffer) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            BrewEffectSerializer brewEffectSerializer = this;
            Potion potion = Potion.getPotionById((int)buffer.readVarInt());
            if (potion == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)potion, (String)"Potion.getPotionById(buffer.readVarInt())!!");
            int n = buffer.readVarInt();
            Potion potion2 = Potion.getPotionById((int)buffer.readVarInt());
            if (potion2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)potion2, (String)"Potion.getPotionById(buffer.readVarInt())!!");
            return new CurseBrewEffect(brewEffectSerializer, potion, n, potion2, buffer.readVarInt());
        }

        @Override
        public void write(@NotNull PacketBuffer buffer, @NotNull CurseBrewEffect effect) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            Intrinsics.checkParameterIsNotNull((Object)effect, (String)"effect");
            buffer.writeVarInt(Potion.getIdFromPotion((Potion)effect.getPotion()));
            buffer.writeVarInt(effect.getBaseDuration());
            buffer.writeVarInt(Potion.getIdFromPotion((Potion)effect.getInvertedPotion()));
            buffer.writeVarInt(effect.getInvertedDuration());
        }

        private Serializer() {
        }

        static {
            Serializer serializer;
            INSTANCE = serializer = new Serializer();
        }
    }
}

