/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.WitcheryUtils;

public class CureDebuffsBrewEffect
extends BrewActionEffect {
    public CureDebuffsBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        ArrayList<Potion> effectsToRemove = new ArrayList<Potion>();
        Collection effects2 = targetEntity.getActivePotionEffects();
        for (PotionEffect effect : effects2) {
            Potion potion = effect.getPotion();
            if (!WitcheryPotion.isDebuff(potion)) continue;
            if (WitcheryPotion.isCurable(potion) && effect.getAmplifier() <= modifiers.getStrength()) {
                effectsToRemove.add(potion);
            }
            if (potion != WitcheryPotionEffects.DISEASED || modifiers.getStrength() < 2) continue;
            effectsToRemove.add(potion);
            if (targetEntity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)targetEntity;
                PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                playerEx.clearCachedIncurablePotionEffect(potion);
            }
            if (modifiers.getStrength() < 3) continue;
            int R = 9;
            BlockPos coord = targetEntity.getPosition();
            for (BlockPos pos : BlockPos.getAllInBox((BlockPos)coord.add(-R, -R, -R), (BlockPos)coord.add(R, R, R))) {
                Block block = world.getBlockState(pos).getBlock();
                if (block != WitcheryBlocks.DISEASE) continue;
                world.setBlockToAir(pos);
            }
        }
        for (Potion potion2 : effectsToRemove) {
            targetEntity.removePotionEffect(potion2);
        }
    }

    @Override
    protected void doApplyRitualToEntity(World world, EntityLivingBase targetEntity, ModifiersRitual ritualModifiers, ModifiersEffect modifiers, ItemStack stack) {
        ArrayList<Potion> effectsToRemove = new ArrayList<Potion>();
        ArrayList<PotionEffect> effectsToAdd = new ArrayList<PotionEffect>();
        Collection effects2 = targetEntity.getActivePotionEffects();
        int modifiedStrength = modifiers.getStrength();
        for (PotionEffect effect : effects2) {
            Potion potion = effect.getPotion();
            if (!WitcheryPotion.isDebuff(potion)) continue;
            if (effect.getAmplifier() < modifiedStrength) {
                effectsToRemove.add(potion);
                if (world.rand.nextDouble() >= 0.01) continue;
                effectsToAdd.add(new PotionEffect(effect.getPotion(), effect.getDuration(), effect.getAmplifier() + 1));
                continue;
            }
            if (effect.getAmplifier() == modifiedStrength) {
                effectsToRemove.add(potion);
                if (world.rand.nextDouble() >= 0.25) continue;
                effectsToAdd.add(new PotionEffect(effect.getPotion(), effect.getDuration(), effect.getAmplifier() + 1));
                continue;
            }
            effectsToRemove.add(potion);
            if (world.rand.nextDouble() >= 0.75) continue;
            effectsToAdd.add(new PotionEffect(effect.getPotion(), effect.getDuration(), effect.getAmplifier() + 1));
        }
        for (Potion potion2 : effectsToRemove) {
            targetEntity.removePotionEffect(potion2);
            if (WitcheryPotion.isCurable(potion2) || !(targetEntity instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)targetEntity;
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            playerEx.clearCachedIncurablePotionEffect(potion2);
        }
        for (PotionEffect potionEffect : effectsToAdd) {
            targetEntity.addPotionEffect(potionEffect);
        }
        if (effectsToAdd.isEmpty()) {
            targetEntity.world.playSound(null, targetEntity.getPosition(), SoundEvents.ENTITY_PLAYER_LEVELUP, SoundCategory.PLAYERS, 0.5f, 0.4f / (targetEntity.world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(targetEntity.posX, targetEntity.posY, targetEntity.posZ, 0.5f, 2.0f, EnumParticleTypes.SPELL), (Entity)targetEntity);
        } else {
            targetEntity.world.playSound(null, targetEntity.getPosition(), SoundEvents.ENTITY_ENDERDRAGON_GROWL, SoundCategory.PLAYERS, 0.5f, 0.4f / (targetEntity.world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(targetEntity.posX, targetEntity.posY, targetEntity.posZ, 0.5f, 2.0f, EnumParticleTypes.SPELL_MOB), (Entity)targetEntity);
        }
    }
}

