/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.action.BrewActionRitual;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.brewing.action.effect.DrawCallback;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;
import net.msrandom.witchery.potion.PotionEnderInhibition;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

public class BrewActionTranspose
extends BrewActionEffect {
    private static final ResourceLocation CIRCLE = new ResourceLocation("witchery", "textures/gui/circles_mpurple.png");

    public BrewActionTranspose(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    public boolean isRitualTargetLocationValid(MinecraftServer server, World world, BlockPos pos, BlockPos target, int dimension, ModifiersRitual modifiers) {
        return BrewActionRitual.isDistanceAllowed(world, pos, target, dimension, modifiers.covenSize, modifiers.leonard) && WitcheryUtils.isCircleGlyph((IBlockAccess)server.getWorld(dimension), target, 3, WitcheryBlocks.GLYPH_OTHERWHERE);
    }

    @Override
    protected void doApplyRitualToBlock(World world, BlockPos p, EnumFacing side, int radius, ModifiersRitual ritual, ModifiersEffect modifiers, ItemStack stack) {
        int height2 = 3;
        BlockPos midSource = ritual.getTarget();
        BlockPos midTarget = ritual.getTarget(1);
        WorldServer worldSource = world.getMinecraftServer().getWorld(ritual.getDimension());
        WorldServer worldTarget = world.getMinecraftServer().getWorld(ritual.getDimension(1));
        for (int y = 0; y < height2; ++y) {
            for (int x = -height2; x <= height2; ++x) {
                for (int z = -height2; z <= height2; ++z) {
                    if (x * x + y * z >= height2 * height2) continue;
                    BlockPos s = midSource.add(x, y, z);
                    BlockPos t = midTarget.add(x, y, z);
                    IBlockState block = world.getBlockState(s);
                    if (!WitcheryUtils.isBlockBreakable((World)worldSource, s, block) || !WitcheryUtils.canBreak(block) || !WitcheryUtils.canBreak(world.getBlockState(t)) || !WitcheryUtils.isBlockBreakable((World)worldTarget, t)) continue;
                    world.setBlockState(t, block, 3);
                    world.setBlockToAir(s);
                }
            }
        }
    }

    @Override
    protected void doApplyRitualToEntity(World world, EntityLivingBase targetEntity, ModifiersRitual ritualModifiers, ModifiersEffect modifiers, ItemStack stack) {
        if (PotionEnderInhibition.canTeleport((Entity)targetEntity, 3)) {
            BlockPos target = ritualModifiers.getTarget();
            WitcheryIngredientItem.teleportToLocation(target, ritualModifiers.getDimension(), (Entity)targetEntity, true);
        }
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        if (PotionEnderInhibition.canTeleport((Entity)targetEntity, modifiers.getStrength())) {
            this.teleportAway(world, modifiers.impactLocation != null ? new BlockPos(modifiers.impactLocation) : new BlockPos((Entity)targetEntity), targetEntity, 10 * (modifiers.getStrength() + 1));
        }
    }

    private void teleportAway(World world, BlockPos pos, EntityLivingBase entity, int range) {
        if (!world.isRemote) {
            int doubleDistance = range * 2;
            for (int attempt = 0; attempt < 3; ++attempt) {
                pos = pos.add(world.rand.nextInt(doubleDistance) - range, 0, world.rand.nextInt(doubleDistance) - range);
                int maxY = Math.min(pos.getY() + 64, 250);
                while (!world.getBlockState(pos).getMaterial().isSolid() && pos.getY() >= 0) {
                    pos = pos.down();
                }
                while (!(world.getBlockState(pos).getMaterial().isSolid() && world.getBlockState(pos).getBlock() != Blocks.BEDROCK && world.isAirBlock(pos.up()) && world.isAirBlock(pos.up(2)) && world.isAirBlock(pos.up(3)) || pos.getY() >= maxY)) {
                    pos = pos.up();
                }
                if (pos.getY() <= 0 || pos.getY() >= maxY) continue;
                WitcheryIngredientItem.teleportToLocation(pos.up(), world.provider.getDimension(), (Entity)entity, true);
                break;
            }
        }
    }

    @Override
    public void drawPage(int page, int baseHeight2, @NotNull DrawCallback drawCentered) {
        if (page == 2) {
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.getMinecraft().getTextureManager().bindTexture(CIRCLE);
            drawCentered.invoke(baseHeight2, 32, 32);
        }
    }
}

