/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.WitcheryBlockLeaves;
import net.msrandom.witchery.block.WitcheryBlockLog;
import net.msrandom.witchery.block.WitcheryBlockPlanks;
import net.msrandom.witchery.block.WitcheryBlockSapling;
import net.msrandom.witchery.block.WitcheryWoodType;
import net.msrandom.witchery.brewing.BrewNamePart;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcheryWoodTypes;
import net.msrandom.witchery.util.BlockUtil;
import org.jetbrains.annotations.NotNull;

public class BrewActionSprouting
extends BrewActionEffect {
    public BrewActionSprouting(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    public static void growBranch(EntityLivingBase entity, int extent) {
        BrewActionSprouting.growBranch(new BlockPos(entity.posX, entity.posY - 1.0, entity.posZ), entity.world, EnumFacing.UP, extent, entity.getEntityBoundingBox().grow(0.5));
    }

    public static void growBranch(BlockPos pos, World world, EnumFacing sideHit, int extent, AxisAlignedBB boundingBox) {
        AxisAlignedBB axisalignedbb;
        List list1;
        BlockPos p;
        int i;
        Block logBlock;
        if (world.isRemote) {
            return;
        }
        IBlockState state = world.getBlockState(pos);
        Block blockID = state.getBlock();
        int var = world.rand.nextInt(4);
        WitcheryWoodType type = null;
        WitcheryWoodType[] types = new WitcheryWoodType[]{WitcheryWoodTypes.ROWAN, WitcheryWoodTypes.ALDER, WitcheryWoodTypes.HAWTHORN};
        if (blockID == Blocks.LOG || blockID == Blocks.PLANKS || blockID == Blocks.SAPLING || blockID == Blocks.LEAVES) {
            logBlock = Blocks.LOG;
        } else if (blockID instanceof WitcheryBlockLog || blockID instanceof WitcheryBlockPlanks || blockID instanceof WitcheryBlockSapling || blockID instanceof WitcheryBlockLeaves) {
            type = types[world.rand.nextInt(types.length)];
            logBlock = type.getLog();
        } else {
            Block block;
            if (world.rand.nextBoolean()) {
                block = Blocks.LOG;
            } else {
                type = types[world.rand.nextInt(types.length)];
                block = type.getLog();
            }
            logBlock = block;
        }
        BlockLeaves leavesBlock = Blocks.LOG == logBlock ? Blocks.LEAVES : type.getLeaves();
        IBlockState logState = logBlock.getDefaultState().withProperty((IProperty)BlockLog.LOG_AXIS, (Comparable)BlockLog.EnumAxis.fromFacingAxis((EnumFacing.Axis)sideHit.getAxis()));
        boolean isInitialBlockSolid = state.getMaterial().isSolid();
        int n = i = sideHit != EnumFacing.UP || isInitialBlockSolid ? 1 : 0;
        while (i <= extent && (p = pos.add(i * sideHit.getDirectionVec().getX(), i * sideHit.getDirectionVec().getY(), i * sideHit.getDirectionVec().getZ())).getY() < 255 && BlockUtil.setBlockIfReplaceable(world, p, logBlock == Blocks.LOG ? logState.withProperty((IProperty)BlockOldLog.VARIANT, (Comparable)BlockPlanks.EnumType.values()[var]) : logState)) {
            int lz;
            int lx = sideHit.getAxis() != EnumFacing.Axis.X && world.rand.nextInt(4) == 0 ? world.rand.nextInt(3) - 1 : 0;
            int ly = sideHit.getAxis() != EnumFacing.Axis.Y && lx == 0 && world.rand.nextInt(4) == 0 ? world.rand.nextInt(3) - 1 : 0;
            int n2 = lz = sideHit.getAxis() != EnumFacing.Axis.Z && lx == 0 && ly == 0 && world.rand.nextInt(4) == 0 ? world.rand.nextInt(3) - 1 : 0;
            if (lx != 0 || ly != 0 || lz != 0) {
                BlockUtil.setBlockIfReplaceable(world, pos.add(lx, ly, lz), leavesBlock == Blocks.LEAVES ? leavesBlock.getDefaultState().withProperty((IProperty)BlockOldLeaf.VARIANT, (Comparable)BlockPlanks.EnumType.values()[var]) : leavesBlock.getDefaultState());
            }
            ++i;
        }
        if (sideHit == EnumFacing.UP && !(list1 = world.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb = boundingBox.expand(0.0, 2.0, 0.0))).isEmpty()) {
            Iterator iterator = list1.iterator();
            BlockPos p2 = pos.add(i * sideHit.getDirectionVec().getX(), i * sideHit.getDirectionVec().getY() + pos.getY() > 255 ? 255 : i * sideHit.getDirectionVec().getY(), i * sideHit.getDirectionVec().getZ());
            while (iterator.hasNext()) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)iterator.next();
                BlockPos p3 = p2.up();
                if (world.getBlockState(p3).getMaterial().isSolid() || world.getBlockState(p3.up()).getMaterial().isSolid()) continue;
                entitylivingbase.setPosition((double)p3.getX() + 0.5, (double)(p3.getY() + 1), (double)p3.getZ() + 0.5);
            }
        }
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack actionStack) {
        AxisAlignedBB bounds = new AxisAlignedBB(pos);
        BrewActionSprouting.growBranch(pos, world, side, 8 + 2 * modifiers.getStrength(), bounds);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        targetEntity.addPotionEffect(new PotionEffect(WitcheryPotionEffects.SPROUTING, modifiers.getModifiedDuration(300), modifiers.getStrength()));
    }

    @Override
    @NotNull
    public BrewNamePart augmentName(@NotNull BrewNamePart namePart) {
        return super.augmentName(namePart).setBaseDuration(300);
    }
}

