/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.potion.PotionEnslaved;
import net.msrandom.witchery.util.WitcheryUtils;

public class BrewActionRaising
extends BrewActionEffect {
    public BrewActionRaising(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    public static void raiseDead(World world, BlockPos coord, int strength, EntityPlayer raiser, int lifetime) {
        int drops = 6;
        BrewActionRaising.raiseUndead(world, coord, raiser, lifetime);
        int extraCount = 0;
        if (strength >= 1 && world.rand.nextDouble() < (double)strength * 0.5) {
            ++extraCount;
        }
        if (strength >= 2 && world.rand.nextDouble() < (double)strength * 0.25) {
            ++extraCount;
        }
        if (strength >= 3 && world.rand.nextDouble() < (double)strength * 0.25) {
            ++extraCount;
        }
        block0: for (int i = 0; i < extraCount; ++i) {
            int minY = coord.getY() - drops;
            BlockPos pos = coord.up(drops);
            while (pos.getY() >= minY) {
                if (world.getBlockState(pos.down()).getMaterial().isSolid() && world.isAirBlock(pos)) {
                    BrewActionRaising.raiseUndead(world, pos, raiser, lifetime);
                    continue block0;
                }
                pos = pos.down();
            }
        }
    }

    private static void raiseUndead(World world, BlockPos coord, EntityPlayer thrower, int lifetime) {
        if (!world.isRemote) {
            EntityLiving undeadEntity = BrewActionRaising.createUndeadCreature(world);
            undeadEntity.setLocationAndAngles(0.5 + (double)coord.getX(), 0.1 + (double)coord.getY(), 0.5 + (double)coord.getZ(), 0.0f, 0.0f);
            undeadEntity.onInitialSpawn(world.getDifficultyForLocation(undeadEntity.getPosition()), null);
            undeadEntity.enablePersistence();
            WitcheryUtils.setNoDrops((EntityLivingBase)undeadEntity, true);
            if (lifetime > 0) {
                undeadEntity.addPotionEffect(new PotionEffect(WitcheryPotionEffects.MORTAL_COIL, lifetime));
            }
            if (thrower != null) {
                PotionEnslaved.setEnslaverForMob(undeadEntity, thrower);
            }
            world.spawnEntity((Entity)undeadEntity);
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(undeadEntity.posX, undeadEntity.posY, undeadEntity.posZ, 0.5f, 2.0f, EnumParticleTypes.SMOKE_LARGE), (Entity)undeadEntity);
        }
    }

    private static EntityLiving createUndeadCreature(World world) {
        double value = world.rand.nextDouble();
        if (value < 0.6) {
            return new EntityZombie(world);
        }
        if (value < 0.97) {
            return new EntitySkeleton(world);
        }
        return new EntityPigZombie(world);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack stack) {
        BrewActionRaising.raiseDead(world, pos.offset(side), modifiers.ritualised ? 0 : modifiers.getStrength(), modifiers.caster, modifiers.ritualised ? (modifiers.getStrength() + 1) * 200 : 0);
    }
}

