/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.util.WitcheryUtils;

public class BrewActionRaiseLand
extends BrewActionEffect {
    public BrewActionRaiseLand(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyRitualToBlock(World world, BlockPos p, EnumFacing side, int radius, ModifiersRitual ritualModifiers, ModifiersEffect modifiers, ItemStack stack) {
        int r = (modifiers.getStrength() + 1) * 2;
        int rsq = r * r;
        for (BlockPos pos : BlockPos.getAllInBox((BlockPos)p.add(-r, -r, -r), (BlockPos)p.add(r, r, r))) {
            int z;
            int x = pos.getX() - p.getX();
            if (x * x + (z = pos.getZ() - p.getZ()) * z >= rsq) continue;
            this.doApplyToBlock(world, pos, EnumFacing.UP, 1, modifiers, stack);
        }
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        this.doApplyToBlock(world, targetEntity.getPosition().down(), EnumFacing.UP, 1, modifiers, stack);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack actionStack) {
        while (!world.isAirBlock(pos.up()) && pos.getY() < 255) {
            pos = pos.up();
        }
        if (WitcheryUtils.canBreak(world.getBlockState(pos)) && WitcheryUtils.isBlockBreakable(world, pos)) {
            int height2 = (modifiers.getStrength() + 1) * (modifiers.ritualised ? 2 : 3);
            if (!world.isRemote) {
                for (int i = 0; i < height2; ++i) {
                    BlockPos p = pos.down(i);
                    IBlockState block = world.getBlockState(p);
                    world.setBlockToAir(p);
                    world.setBlockState(p.up(height2), block, 3);
                }
            }
            AxisAlignedBB bounds = new AxisAlignedBB(pos, pos.add(1, 2, 1));
            List list2 = world.getEntitiesWithinAABB(EntityLivingBase.class, bounds);
            double x = (double)pos.getX() + 0.5;
            double y = pos.getY() + height2 + 1;
            double z = (double)pos.getZ() + 0.5;
            for (EntityLivingBase entity : list2) {
                entity.setPositionAndUpdate(x, y, z);
            }
        }
    }
}

