/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.util.BlockActionCircle;
import net.msrandom.witchery.util.EntityUtil;

public class BrewActionPlanting
extends BrewActionEffect {
    public BrewActionPlanting(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, final ModifiersEffect modifiers, ItemStack stack) {
        int R = radius + modifiers.getStrength();
        double RADIUS_SQ = R * R;
        AxisAlignedBB areaOfEffect = new AxisAlignedBB(pos.add(-R, -R, -R), pos.add(R, R, R));
        List entities = world.getEntitiesWithinAABB(EntityItem.class, areaOfEffect);
        if (!entities.isEmpty()) {
            final ArrayList<ItemStack> seeds = new ArrayList<ItemStack>();
            for (EntityItem itemEntity : entities) {
                ItemStack seedStack = itemEntity.getItem();
                if (!(itemEntity.getDistanceSq(pos) <= RADIUS_SQ) || !(seedStack.getItem() instanceof IPlantable)) continue;
                seeds.add(seedStack);
            }
            new BlockActionCircle(){

                @Override
                public void onBlock(World world, BlockPos p) {
                    int index = seeds.size() - 1;
                    if (index >= 0) {
                        ItemStack seed = (ItemStack)seeds.get(index);
                        for (BlockPos pos : BlockPos.getAllInBox((BlockPos)p.down(2), (BlockPos)p.up(2))) {
                            IBlockState block = world.getBlockState(pos);
                            EntityPlayer player = EntityUtil.playerOrFake(world, (EntityLivingBase)modifiers.caster);
                            ItemStack old = player.getHeldItemMainhand();
                            player.setHeldItem(EnumHand.MAIN_HAND, seed);
                            if (block.getMaterial().isSolid() && world.isAirBlock(pos.up()) && seed.getItem().onItemUse(player, world, pos, EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f) == EnumActionResult.SUCCESS) {
                                player.setHeldItem(EnumHand.MAIN_HAND, old);
                                break;
                            }
                            player.setHeldItem(EnumHand.MAIN_HAND, old);
                        }
                        if (seed.isEmpty()) {
                            seeds.remove(index);
                        }
                    }
                }
            }.processFilledCircle(world, pos, radius + modifiers.getStrength());
        }
    }
}

