/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockWitchLilyPad;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.util.WitcheryUtils;

public class BrewActionLilify
extends BrewActionEffect {
    public BrewActionLilify(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack actionStack) {
        pos = pos.offset(side);
        while (!(world.getBlockState(pos).getMaterial() == Material.WATER && world.isAirBlock(pos.up()) || pos.getY() >= 255)) {
            pos = pos.up();
        }
        if (world.getBlockState(pos).getMaterial() == Material.WATER && world.isAirBlock(pos.up()) && WitcheryUtils.isBlockBreakable(world, pos.up())) {
            world.setBlockState(pos.up(), WitcheryBlocks.LILY.getDefaultState().withProperty((IProperty)BlockWitchLilyPad.GROWTH, (Comparable)Integer.valueOf(modifiers.getStrength() << 2)), 3);
        }
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        this.doApplyToBlock(world, targetEntity.getPosition(), EnumFacing.UP, 1, modifiers, actionStack);
    }
}

