/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockCircle;
import net.msrandom.witchery.block.BlockCircleGlyph;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.util.WitcheryUtils;

public class BrewActionFelling
extends BrewActionEffect {
    public BrewActionFelling(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos p, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack stack) {
        int strength = Math.max(modifiers.getStrength(), 0);
        int r = Math.max(radius, 1);
        int rSq = r * r;
        for (BlockPos pos : BlockPos.getAllInBox((BlockPos)p.add(-r, -r, -r), (BlockPos)p.add(r, r, r))) {
            if (!(pos.distanceSq((Vec3i)p) <= (double)rSq) || !WitcheryUtils.isBlockBreakable(world, pos)) continue;
            IBlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            Material material = state.getMaterial();
            if (material != Material.WOOD || !block.canSustainLeaves(state, (IBlockAccess)world, pos) || block instanceof BlockCircle || block instanceof BlockCircleGlyph) continue;
            block.dropBlockAsItem(world, pos, state, strength);
            world.setBlockToAir(pos);
        }
    }
}

