/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.action.effect.BrewEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import org.jetbrains.annotations.NotNull;

public abstract class BrewActionEffect
extends BrewEffect {
    private final boolean invertible;

    public BrewActionEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer);
        this.invertible = invertible;
    }

    @Override
    public boolean isInvertible() {
        return this.invertible;
    }

    @Override
    public final void applyRitualToEntity(World world, EntityLivingBase victim, ModifiersRitual ritualModifiers, ModifiersEffect modifiers, ItemStack stack) {
        if (!modifiers.disableEntityTarget) {
            this.doApplyRitualToEntity(world, victim, ritualModifiers, modifiers, stack);
            modifiers.reset();
        }
    }

    @Override
    public final void applyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        if (!modifiers.disableEntityTarget) {
            this.doApplyToEntity(world, targetEntity, modifiers, stack);
            modifiers.reset();
        }
    }

    protected void doApplyRitualToEntity(World world, EntityLivingBase targetEntity, ModifiersRitual ritualModifiers, ModifiersEffect modifiers, ItemStack stack) {
        this.doApplyToEntity(world, targetEntity, modifiers, stack);
    }

    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
    }

    @Override
    public final void applyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack stack) {
        if (!modifiers.disableBlockTarget) {
            this.doApplyToBlock(world, pos, side, radius, modifiers, stack);
            modifiers.reset();
        }
    }

    @Override
    public final void applyRitualToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersRitual ritualModifiers, ModifiersEffect effectModifiers, ItemStack stack) {
        if (!effectModifiers.disableBlockTarget) {
            this.doApplyRitualToBlock(world, pos, side, radius, ritualModifiers, effectModifiers, stack);
            effectModifiers.reset();
        }
    }

    protected void doApplyRitualToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersRitual ritualModifiers, ModifiersEffect modifiers, ItemStack stack) {
        this.doApplyToBlock(world, pos, side, radius, modifiers, stack);
    }

    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack stack) {
    }

    @Override
    @NotNull
    public String getDefaultKey(boolean description, boolean inverted) {
        ResourceLocation key = (ResourceLocation)BrewEffectSerializer.REGISTRY.getKey(this.getSerializer());
        String name2 = "brew." + key.getNamespace() + "." + key.getPath();
        return inverted ? name2 + ".inverted" : name2;
    }
}

