/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.util.BlockActionCircle;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class BrewActionBlight
extends BrewActionEffect {
    public BrewActionBlight(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack stack) {
        if (BlockUtil.isReplaceableBlock(world, pos)) {
            pos = pos.down();
        }
        new BlockActionCircle(){

            @Override
            public void onBlock(World world, BlockPos pos) {
                if (WitcheryUtils.isBlockBreakable(world, pos)) {
                    IBlockState state = world.getBlockState(pos);
                    Block block = state.getBlock();
                    IBlockState stateBelow = world.getBlockState(pos.down());
                    Block blockBelow = stateBelow.getBlock();
                    if (block == Blocks.TALLGRASS) {
                        world.setBlockToAir(pos);
                        BrewActionBlight.this.blightGround(world, pos.down(), blockBelow);
                    } else if (block == Blocks.RED_FLOWER || block == Blocks.YELLOW_FLOWER || block == Blocks.CARROTS || block == Blocks.WHEAT || block == Blocks.POTATOES || block == Blocks.PUMPKIN_STEM || block == Blocks.MELON_STEM || block == Blocks.MELON_BLOCK || block == Blocks.PUMPKIN || block == Blocks.DOUBLE_PLANT) {
                        world.setBlockState(pos, Blocks.DEADBUSH.getDefaultState());
                        BrewActionBlight.this.blightGround(world, pos.down(), blockBelow);
                    } else if (block == Blocks.FARMLAND) {
                        world.setBlockState(pos, Blocks.SAND.getDefaultState());
                    } else if (state.getMaterial().isSolid()) {
                        BrewActionBlight.this.blightGround(world, pos, block);
                    } else if (stateBelow.getMaterial().isSolid()) {
                        BrewActionBlight.this.blightGround(world, pos.down(), blockBelow);
                    }
                }
            }
        }.processFilledCircle(world, pos.up(), radius);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        if (targetEntity instanceof EntityVillager && world.rand.nextInt(10 - modifiers.getStrength() * 2) == 0) {
            EntityZombieVillager entityzombie = new EntityZombieVillager(world);
            entityzombie.copyLocationAndAnglesFrom((Entity)targetEntity);
            world.removeEntity((Entity)targetEntity);
            entityzombie.onInitialSpawn(world.getDifficultyForLocation(entityzombie.getPosition()), null);
            entityzombie.setForgeProfession(((EntityVillager)targetEntity).getProfessionForge());
            if (targetEntity.isChild()) {
                entityzombie.setChild(true);
            }
            world.spawnEntity((Entity)entityzombie);
            world.playEvent(1016, entityzombie.getPosition(), 0);
        } else if (targetEntity instanceof EntityCow && world.rand.nextInt(20 - modifiers.getStrength() * 3) == 0) {
            EntityMooshroom entityzombie2 = new EntityMooshroom(world);
            entityzombie2.copyLocationAndAnglesFrom((Entity)targetEntity);
            world.removeEntity((Entity)targetEntity);
            entityzombie2.onInitialSpawn(world.getDifficultyForLocation(entityzombie2.getPosition()), null);
            world.spawnEntity((Entity)entityzombie2);
            world.playEvent(1016, entityzombie2.getPosition(), 0);
        } else if (targetEntity instanceof EntityAnimal && world.rand.nextInt(modifiers.getStrength() > 1 ? 2 : 3) == 0) {
            targetEntity.attackEntityFrom(DamageSource.MAGIC, 20.0f);
        }
    }

    public void blightGround(World world, BlockPos pos, Block blockBelowID) {
        if (blockBelowID == Blocks.DIRT || blockBelowID == Blocks.GRASS || blockBelowID == Blocks.MYCELIUM || blockBelowID == Blocks.FARMLAND) {
            int rand = world.rand.nextInt(5);
            if (rand == 0) {
                world.setBlockState(pos, Blocks.SAND.getDefaultState());
            } else if (rand == 1) {
                world.setBlockState(pos, Blocks.DIRT.getDefaultState());
            }
        }
    }
}

