/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.item.BiomeHolder;

public class BrewActionBiomeChange
extends BrewActionEffect {
    public BrewActionBiomeChange(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    public void prepareSplashPotion(World world, BrewActionList actionList, ModifiersImpact modifiers) {
        super.prepareSplashPotion(world, actionList, modifiers);
        modifiers.setOnlyInstant();
    }

    @Override
    protected void doApplyRitualToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersRitual ritualModifiers, ModifiersEffect modifiers, ItemStack stack) {
        Biome biome = ((BiomeHolder)stack.getItem()).getBiome(stack);
        int maxRadius = 16 + modifiers.getStrength() * 16;
        this.changeBiome(world, pos, maxRadius, biome);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack actionStack) {
        Biome biome = ((BiomeHolder)actionStack.getItem()).getBiome(actionStack);
        this.changeBiome(world, pos, 1 + modifiers.getStrength(), biome);
    }

    protected void changeBiome(World world, BlockPos pos, int radius, Biome biome) {
        HashMap<ChunkPos, byte[]> chunkMap = new HashMap<ChunkPos, byte[]>();
        this.drawFilledCircle(world, pos, radius, chunkMap, biome);
        for (Map.Entry<ChunkPos, byte[]> entry2 : chunkMap.entrySet()) {
            ChunkPos chunkPos = entry2.getKey();
            Chunk chunk = world.getChunk(chunkPos.x, chunkPos.z);
            chunk.setBiomeArray(entry2.getValue());
            chunk.markDirty();
            SPacketChunkData packet2 = new SPacketChunkData(chunk, 65535);
            for (EntityPlayer playerEntity : world.playerEntities) {
                ((EntityPlayerMP)playerEntity).connection.sendPacket((Packet)packet2);
            }
        }
    }

    private void drawFilledCircle(World world, BlockPos pos, int radius, HashMap<ChunkPos, byte[]> chunkMap, Biome biome) {
        if (radius == 1) {
            this.drawLine(world, pos, pos, chunkMap, biome);
        } else {
            int x = --radius;
            int radiusError = 1 - x;
            for (int z = 0; x >= z; ++z) {
                this.drawLine(world, pos.add(-x, 0, z), pos.add(x, 0, z), chunkMap, biome);
                this.drawLine(world, pos.add(-z, 0, x), pos.add(z, 0, x), chunkMap, biome);
                this.drawLine(world, pos.add(-x, 0, -z), pos.add(x, 0, -z), chunkMap, biome);
                this.drawLine(world, pos.add(-z, 0, -x), pos.add(z, 0, -x), chunkMap, biome);
                if (radiusError < 0) {
                    radiusError += 2 * z + 1;
                    continue;
                }
                radiusError += 2 * (z - --x + 1);
            }
        }
    }

    private void drawLine(World world, BlockPos x1, BlockPos x2, HashMap<ChunkPos, byte[]> chunkMap, Biome biome) {
        for (BlockPos pos : BlockPos.getAllInBox((BlockPos)x1, (BlockPos)x2)) {
            ChunkPos coord = new ChunkPos(pos);
            byte[] map = chunkMap.get(coord);
            if (map == null) {
                Chunk chunk = world.getChunk(pos);
                map = (byte[])chunk.getBiomeArray().clone();
                chunkMap.put(coord, map);
            }
            map[(pos.getZ() & 0xF) << 4 | pos.getX() & 0xF] = (byte)Biome.getIdForBiome((Biome)biome);
            if (biome.getRainfall() != 0.0f || world.getBlockState(pos = world.getTopSolidOrLiquidBlock(pos)).getBlock() != Blocks.SNOW_LAYER) continue;
            world.setBlockToAir(pos);
        }
    }
}

