/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.entity.passive.EntityOwl;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;

public class BodegaBrewEffect
extends BrewActionEffect {
    public BodegaBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        if (modifiers.caster != null && Familiars.hasFamiliarPower(modifiers.caster, WitcheryFamiliars.BROOM_MASTERY) && !(targetEntity instanceof EntityOwl) && !(targetEntity instanceof EntityBat)) {
            int BIRD_COUNT = (modifiers.powerScalingFactor != 1.0 || modifiers.isGlancing ? 1 : 3 + world.rand.nextInt(2)) + modifiers.getStrength();
            if (modifiers.powerScalingFactor == 1.0 && !modifiers.isGlancing || world.rand.nextInt(20) == 0) {
                this.explodeBirds(world, targetEntity, BIRD_COUNT);
            }
        }
    }

    private void explodeBirds(World world, EntityLivingBase victim, int birds) {
        for (int i = 0; i < birds; ++i) {
            EntityOwl owl2 = new EntityOwl(world);
            owl2.setLocationAndAngles(victim.posX - 2.0 + (double)world.rand.nextInt(5), victim.posY + (double)victim.height + 1.0 + (double)world.rand.nextInt(2), victim.posZ - 2.0 + (double)world.rand.nextInt(5), 0.0f, 0.0f);
            owl2.setAttackTarget(victim);
            owl2.setTimeToLive(400);
            world.spawnEntity((Entity)owl2);
            owl2.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(owl2.posX, owl2.posY, owl2.posZ, 1.0f, 1.0f, EnumParticleTypes.PORTAL), (Entity)owl2);
        }
    }
}

