/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;

public class BlastBrewEffect
extends BrewActionEffect {
    public BlastBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        if (modifiers.powerScalingFactor == 1.0 || world.rand.nextDouble() < modifiers.powerScalingFactor * 0.2) {
            world.createExplosion((Entity)modifiers.caster, targetEntity.posX, targetEntity.posY, targetEntity.posZ, (float)modifiers.getStrength(), true);
        }
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack stack) {
        pos = pos.offset(side);
        world.createExplosion((Entity)modifiers.caster, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (float)modifiers.getStrength(), true);
    }
}

