/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.entity.passive.EntityOwl;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.WitcheryUtils;

public class BatBurstBrewEffect
extends BrewActionEffect {
    public BatBurstBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack actionStack) {
        int BAT_COUNT = (modifiers.powerScalingFactor != 1.0 || modifiers.isGlancing || modifiers.strengthPenalty > 0 ? 1 : 10) + modifiers.getStrength();
        this.explodeBats(world, pos, side, BAT_COUNT);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        if (!(targetEntity instanceof EntityOwl) && !(targetEntity instanceof EntityBat)) {
            int BAT_COUNT = (modifiers.powerScalingFactor != 1.0 || modifiers.isGlancing ? 1 : 10) + modifiers.getStrength();
            if (modifiers.powerScalingFactor == 1.0 && !modifiers.isGlancing || world.rand.nextInt(20) == 0) {
                this.explodeBats(world, targetEntity.getPosition(), EnumFacing.UP, BAT_COUNT);
            }
        }
    }

    private void explodeBats(World world, BlockPos coord, EnumFacing side, int bats) {
        BlockPos pos = coord.offset(side);
        for (int i = 0; i < bats; ++i) {
            EntityBat bat = new EntityBat(world);
            WitcheryUtils.setNoDrops((EntityLivingBase)bat, true);
            bat.setLocationAndAngles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            world.spawnEntity((Entity)bat);
        }
        world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.ENTITY_ENDERMEN_TELEPORT, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 3.0f, 3.0f, EnumParticleTypes.EXPLOSION_NORMAL), world, pos);
    }
}

