/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.entity.familiar.Familiar;
import net.msrandom.witchery.entity.familiar.Familiars;

public class AnimalAttractionBrewEffect
extends BrewActionEffect {
    public AnimalAttractionBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        double radius = (modifiers.getStrength() + 1) * 16;
        double radiusSq = radius * radius;
        AxisAlignedBB bounds = targetEntity.getEntityBoundingBox().expand(radius, radius, radius);
        for (EntityLivingBase otherEntity : world.getEntitiesWithinAABB(EntityLivingBase.class, bounds)) {
            if (otherEntity == targetEntity || !(otherEntity.getDistanceSq((Entity)targetEntity) < radiusSq)) continue;
            if (Familiars.canBeFamiliar((Entity)otherEntity)) {
                Familiar<EntityLivingBase> familiar = Familiars.getFamiliarInstance(otherEntity);
                if (familiar.isFamiliar()) continue;
                EntityLivingBase entity = familiar.getEntity();
                Entity owner = familiar.getOwner();
                if (!modifiers.inverted) {
                    if (owner == null) {
                        familiar.setFamiliarTamed(true);
                        if (entity instanceof EntityLiving) {
                            EntityLiving living = (EntityLiving)entity;
                            living.getNavigator().clearPath();
                            living.setAttackTarget(null);
                            living.setHealth(20.0f);
                        }
                        familiar.setFamiliarOwnerId(targetEntity.getUniqueID());
                        world.setEntityState((Entity)entity, (byte)7);
                    }
                } else if (targetEntity != owner) {
                    familiar.setFamiliarTamed(false);
                    if (entity instanceof EntityLiving) {
                        EntityLiving living = (EntityLiving)entity;
                        living.getNavigator().clearPath();
                        living.setAttackTarget(null);
                    }
                    familiar.setFamiliarOwnerId(null);
                    world.setEntityState((Entity)entity, (byte)6);
                }
            } else if (otherEntity instanceof EntityTameable) {
                EntityTameable tameable = (EntityTameable)otherEntity;
                EntityLivingBase owner = tameable.getOwner();
                if (!modifiers.inverted) {
                    if (owner == null) {
                        tameable.setTamed(true);
                        tameable.getNavigator().clearPath();
                        tameable.setAttackTarget(null);
                        tameable.setHealth(20.0f);
                        tameable.setOwnerId(targetEntity.getUniqueID());
                        world.setEntityState((Entity)tameable, (byte)7);
                    }
                } else if (targetEntity != owner) {
                    tameable.setTamed(false);
                    tameable.getNavigator().clearPath();
                    tameable.setAttackTarget(null);
                    tameable.setOwnerId(null);
                    world.setEntityState((Entity)tameable, (byte)6);
                }
            }
            if (!(otherEntity instanceof EntityLiving)) continue;
            EntityLiving entity = (EntityLiving)otherEntity;
            if (!modifiers.inverted) {
                if (entity.getNavigator().tryMoveToXYZ(targetEntity.posX, targetEntity.posY, targetEntity.posZ, 1.0)) continue;
                entity.getNavigator().getPathToEntityLiving((Entity)targetEntity);
                continue;
            }
            int RANGE = 6;
            int newX = MathHelper.floor((double)targetEntity.posX) + (world.rand.nextBoolean() ? 1 : -1) * (RANGE + world.rand.nextInt(RANGE));
            int newZ = MathHelper.floor((double)targetEntity.posZ) + (world.rand.nextBoolean() ? 1 : -1) * (RANGE + world.rand.nextInt(RANGE));
            int newY = 62;
            while (!world.isAirBlock(new BlockPos(newX, newY + 1, newZ))) {
                ++newY;
            }
            if (entity.getNavigator().tryMoveToXYZ((double)newX, (double)newY, (double)newZ, 1.0)) continue;
            entity.setPositionAndUpdate(0.5 + (double)newX, (double)newY, 0.5 + (double)newZ);
        }
    }
}

