/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action;

import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ItemKey;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.RitualStatus;
import net.msrandom.witchery.brewing.action.BrewAction;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.brewing.action.BrewActionSerializer;

public class BrewActionRitual
extends BrewAction {
    private final boolean aoeOnly;

    public BrewActionRitual(ItemKey itemKey, BrewActionSerializer<?> serializer, int powerCost, boolean aoeOnly) {
        super(itemKey, serializer, null, powerCost, false, false, null);
        this.aoeOnly = aoeOnly;
    }

    public static boolean isDistanceAllowed(World world, BlockPos pos, BlockPos target, int dimension, int covenSize, boolean leonard) {
        int rangeScale;
        int allowedRange;
        if (world.provider.getDimension() != dimension) {
            return covenSize >= 6 && leonard;
        }
        if (covenSize >= 6) {
            return true;
        }
        double rangeSq = pos.distanceSq((Vec3i)target);
        return rangeSq <= (double)((allowedRange = 2 * (rangeScale = (1 + covenSize) * 4) * rangeScale) * allowedRange);
    }

    @Override
    public final boolean triggersRitual() {
        return true;
    }

    @Override
    public final boolean canAdd(BrewActionList actionList, boolean splash, boolean isCauldronFull, boolean hasEffects) {
        return isCauldronFull && hasEffects && (!this.aoeOnly || splash);
    }

    @Override
    public RitualStatus updateRitual(MinecraftServer server, BrewActionList actionList, World world, BlockPos position, ModifiersRitual modifiers, ModifiersImpact impactModifiers, ModifiersEffect effectModifiers) {
        BlockPos target = modifiers.getTarget();
        if (!BrewActionRitual.isDistanceAllowed(world, position, target, modifiers.getDimension(), modifiers.covenSize, modifiers.leonard)) {
            return RitualStatus.failure(RitualStatus.Failure.TARGET_TOO_FAR);
        }
        if (actionList.isTargetLocationValid(server, world, position, target, modifiers.getDimension(), modifiers)) {
            return RitualStatus.failure(RitualStatus.Failure.INVALID_CIRCLES);
        }
        return impactModifiers.getDispersal().onUpdateRitual(world, position, actionList.getTagCompound(), modifiers, impactModifiers);
    }
}

