/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action;

import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ItemKey;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.action.BrewAction;
import net.msrandom.witchery.resources.BrewActionManager;
import org.jetbrains.annotations.NotNull;

public class BrewActionList {
    public final ArrayList<BrewAction> actions = new ArrayList();
    public final ArrayList<ItemStack> items = new ArrayList();
    private final NBTTagCompound nbtBrew;

    public BrewActionList() {
        this.nbtBrew = new NBTTagCompound();
    }

    public BrewActionList(NBTTagCompound nbtBrew) {
        this.nbtBrew = nbtBrew;
        if (nbtBrew != null) {
            NBTTagList nbtItems = nbtBrew.getTagList("Items", 10);
            int count = nbtItems.tagCount();
            for (int i = 0; i < count; ++i) {
                NBTTagCompound nbtItem = nbtItems.getCompoundTagAt(i);
                ItemStack stack = new ItemStack(nbtItem);
                BrewAction brewAction = BrewActionManager.INSTANCE.getAction(ItemKey.fromStack(stack));
                if (brewAction == null) continue;
                this.actions.add(brewAction);
                this.items.add(stack);
                this.nullifyItems(brewAction);
            }
        }
    }

    public ItemStack getTopItemStack() {
        return this.size() > 0 ? this.items.get(this.size() - 1) : ItemStack.EMPTY;
    }

    public BrewAction getTopAction() {
        return this.size() > 0 ? this.actions.get(this.size() - 1) : null;
    }

    public int size() {
        return this.actions.size();
    }

    public NBTTagCompound getTagCompound() {
        return this.nbtBrew;
    }

    public void nullifyItems(BrewAction brewAction) {
        brewAction.processNullification(this);
    }

    public void applyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers) {
        for (int i = 0; i < this.actions.size(); ++i) {
            BrewAction action = this.actions.get(i);
            if (!action.augmentEffectLevels(modifiers.effectLevel)) continue;
            action.augmentEffectModifiers(modifiers);
            action.applyToEntity(world, targetEntity, modifiers, this.items.get(i));
        }
    }

    public void applyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers) {
        for (int i = 0; i < this.actions.size(); ++i) {
            BrewAction action = this.actions.get(i);
            if (!action.augmentEffectLevels(modifiers.effectLevel)) continue;
            action.augmentEffectModifiers(modifiers);
            action.applyToBlock(world, pos, side, radius, modifiers, this.items.get(i));
        }
    }

    public void applyRitualToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersRitual ritualModifiers, ModifiersEffect modifiers) {
        for (int i = 0; i < this.actions.size(); ++i) {
            BrewAction action = this.actions.get(i);
            if (!action.augmentEffectLevels(modifiers.effectLevel)) continue;
            action.augmentEffectModifiers(modifiers);
            action.applyRitualToBlock(world, pos, side, radius, ritualModifiers, modifiers, this.items.get(i));
        }
    }

    public void applyRitualToEntity(World world, EntityLivingBase targetEntity, ModifiersRitual ritualModifiers, ModifiersEffect modifiers) {
        for (int i = 0; i < this.actions.size(); ++i) {
            BrewAction action = this.actions.get(i);
            if (!action.augmentEffectLevels(modifiers.effectLevel)) continue;
            action.augmentEffectModifiers(modifiers);
            action.applyRitualToEntity(world, targetEntity, ritualModifiers, modifiers, this.items.get(i));
        }
    }

    public boolean isTargetLocationValid(MinecraftServer server, World world, BlockPos pos, BlockPos target, int dimension, ModifiersRitual modifiers) {
        for (BrewAction action : this.actions) {
            if (action.isRitualTargetLocationValid(server, world, pos, target, dimension, modifiers)) continue;
            return true;
        }
        return false;
    }

    public void copy(@NotNull BrewActionList brewActionList) {
        this.items.clear();
        this.actions.clear();
        this.items.addAll(brewActionList.items);
        this.actions.addAll(brewActionList.actions);
    }
}

