/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing;

import java.util.List;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.WitcheryCursedBlock;
import net.msrandom.witchery.block.entity.TileEntityCursedBlock;
import net.msrandom.witchery.brewing.Dispersal;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.RitualStatus;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.WitcheryUtils;

public class TriggeredDispersal
extends Dispersal {
    public TriggeredDispersal() {
        super(2, {"brewing"}, {"rituals"});
    }

    @Override
    public void onImpactSplashPotion(World world, NBTTagCompound nbtBrew, RayTraceResult mop, ModifiersImpact modifiers) {
        boolean replaceable;
        BlockPos coord;
        if (mop != null) {
            switch (mop.typeOfHit) {
                case BLOCK: {
                    coord = mop.getBlockPos().offset(mop.sideHit);
                    break;
                }
                case ENTITY: {
                    coord = mop.entityHit.getPosition();
                    break;
                }
                default: {
                    coord = new BlockPos(modifiers.impactPosition);
                    break;
                }
            }
        } else {
            coord = new BlockPos(modifiers.impactPosition);
        }
        if (replaceable = WitcheryUtils.isBlockBreakable(world, coord)) {
            TileEntityCursedBlock tile;
            IBlockState state = world.getBlockState(coord);
            Block block = state.getBlock();
            BlockContainer cursed = WitcheryBlocks.CURSED_BLOCKS.get(block);
            if (cursed != null) {
                // empty if block
            }
            if (block == Blocks.STONE_BUTTON) {
                WitcheryBlocks.CURSED_BUTTON_STONE.replaceButton(world, coord, modifiers, nbtBrew);
                return;
            }
            if (block == Blocks.WOODEN_BUTTON) {
                WitcheryBlocks.CURSED_BUTTON_WOOD.replaceButton(world, coord, modifiers, nbtBrew);
                return;
            }
            if (block == Blocks.LEVER) {
                WitcheryBlocks.CURSED_LEVER.replaceButton(world, coord, modifiers, nbtBrew);
                return;
            }
            if (block.hasTileEntity(state) && (tile = WitcheryTileEntities.CURSED_BLOCK.getAt((IBlockAccess)world, coord)) != null) {
                tile.updateCurse(modifiers, nbtBrew);
            }
            if (mop != null) {
                switch (mop.typeOfHit) {
                    case BLOCK: {
                        coord = mop.getBlockPos();
                        break;
                    }
                    case ENTITY: {
                        coord = mop.entityHit.getPosition();
                        break;
                    }
                    default: {
                        coord = new BlockPos(modifiers.impactPosition);
                        break;
                    }
                }
            } else {
                coord = new BlockPos(modifiers.impactPosition);
            }
            if ((block = (state = world.getBlockState(coord)).getBlock()) == Blocks.WOODEN_PRESSURE_PLATE) {
                WitcheryBlocks.CURSED_WOODEN_PRESSURE_PLATE.replaceButton(world, coord, modifiers, nbtBrew);
            } else if (block == Blocks.STONE_PRESSURE_PLATE) {
                WitcheryBlocks.CURSED_STONE_PRESSURE_PLATE.replaceButton(world, coord, modifiers, nbtBrew);
            } else if (block == WitcheryBlocks.SNOW_PRESSURE_PLATE) {
                WitcheryBlocks.CURSED_SNOW_PRESSURE_PLATE.replaceButton(world, coord, modifiers, nbtBrew);
            } else if (block == Blocks.OAK_DOOR) {
                WitcheryBlocks.CURSED_WOODEN_DOOR.replaceButton(world, coord, modifiers, nbtBrew);
            } else if (block.hasTileEntity(state)) {
                TileEntityCursedBlock tile2;
                BlockPos pos = coord;
                if (block == WitcheryBlocks.CURSED_WOODEN_DOOR) {
                    IBlockState iblockstate;
                    BlockPos blockpos = state.getValue((IProperty)BlockDoor.HALF) == BlockDoor.EnumDoorHalf.LOWER ? coord : coord.down();
                    IBlockState iBlockState = iblockstate = coord.equals((Object)blockpos) ? state : world.getBlockState(blockpos);
                    if (iblockstate.getBlock() == WitcheryBlocks.CURSED_WOODEN_DOOR) {
                        pos = pos.down();
                    }
                }
                if ((tile2 = WitcheryTileEntities.CURSED_BLOCK.getAt((IBlockAccess)world, pos)) != null) {
                    tile2.updateCurse(modifiers, nbtBrew);
                }
            }
        }
    }

    @Override
    public RitualStatus onUpdateRitual(World world, BlockPos pos, NBTTagCompound nbtBrew, ModifiersRitual modifiers, ModifiersImpact impactModifiers) {
        AxisAlignedBB bounds = new AxisAlignedBB(pos.up(), pos.add(1, 2, 1));
        List items = world.getEntitiesWithinAABB(EntityItem.class, bounds);
        for (EntityItem item : items) {
            NBTTagCompound nbtCurse;
            ItemStack stack = item.getItem();
            if (stack.isEmpty()) continue;
            if (stack.getCount() > 1) {
                stack = stack.splitStack(1);
                EntityItem newEntity = new EntityItem(item.world, item.posX, item.posY, item.posZ, stack);
                world.spawnEntity((Entity)newEntity);
            }
            if (!stack.hasTagCompound()) {
                stack.setTagCompound(new NBTTagCompound());
            }
            NBTTagCompound nbtRoot = stack.getTagCompound();
            AxisAlignedBB playerBounds = bounds.expand(3.0, 3.0, 3.0);
            List players = world.getEntitiesWithinAABB(EntityPlayer.class, playerBounds);
            boolean catNear = false;
            for (EntityPlayer player : players) {
                if (!Familiars.hasFamiliarPower(player, WitcheryFamiliars.CURSE_MASTERY)) continue;
                catNear = true;
                break;
            }
            if (nbtRoot.hasKey("WitcheryCurse") && ((NBTTagCompound)nbtRoot.getCompoundTag("WitcheryCurse").getTag("Curse")).getTagList("Items", 10).equals((Object)nbtBrew.getTagList("Items", 10))) {
                nbtCurse = nbtRoot.getCompoundTag("WitcheryCurse");
                nbtCurse.setInteger("Count", nbtCurse.getInteger("Count") + (catNear ? 2 : 1));
            } else {
                nbtCurse = new NBTTagCompound();
                nbtCurse.setTag("Curse", (NBTBase)nbtBrew.copy());
                nbtCurse.setInteger("Count", catNear ? 2 : 1);
                nbtRoot.setTag("WitcheryCurse", (NBTBase)nbtCurse);
            }
            item.world.playSound(null, item.getPosition(), SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, SoundCategory.PLAYERS, 0.5f, 0.4f / (item.world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(item.posX, item.posY, item.posZ, 0.5f, 0.5f, EnumParticleTypes.EXPLOSION_NORMAL), (Entity)item);
            return RitualStatus.success(true);
        }
        return RitualStatus.failure(RitualStatus.Failure.OTHER_FAILURE);
    }

    public static void registerCurseSelector(Function1<Block, WitcheryCursedBlock> function) {
    }
}

