/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing;

import net.minecraft.util.ResourceLocation;
import net.msrandom.witchery.registry.WitcheryRegistry;
import org.jetbrains.annotations.NotNull;

public class RitualStatus {
    private static final RitualStatus COMPLETE = new RitualStatus(Type.COMPLETE, null);
    private static final RitualStatus ONGOING = new RitualStatus(Type.ONGOING, null);
    private final Type type;
    private final Failure failure;

    private RitualStatus(Type type, Failure failure) {
        this.type = type;
        this.failure = failure;
    }

    @NotNull
    public static RitualStatus success(boolean complete) {
        return complete ? COMPLETE : ONGOING;
    }

    public static RitualStatus failure(Failure failure) {
        return new RitualStatus(Type.FAILED, failure);
    }

    public Type getType() {
        return this.type;
    }

    public Failure getFailure() {
        return this.failure;
    }

    public static class Failure {
        public static final WitcheryRegistry<ResourceLocation, Failure> REGISTRY = new WitcheryRegistry(5);
        public static final Failure TARGET_TOO_FAR = Failure.add("target_too_far", 34816);
        public static final Failure NO_COVEN = Failure.add("no_coven", 136);
        public static final Failure INVALID_CIRCLES = Failure.add("invalid_circles", 0x880000);
        public static final Failure UNDERPOWERED = Failure.add("underpowered", 0xDD8800);
        public static final Failure OTHER_FAILURE = Failure.add("other", 0x880088);
        private final int color;

        public Failure(int color2) {
            this.color = color2;
        }

        private static Failure add(String name2, int color2) {
            Failure failure = new Failure(color2);
            REGISTRY.set(new ResourceLocation("witchery", name2), failure);
            return failure;
        }

        public int getColor() {
            return this.color;
        }
    }

    public static enum Type {
        COMPLETE,
        ONGOING,
        FAILED;

    }
}

