/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.msrandom.witchery.brewing.EffectLevelCounter;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.UpgradableModifier;

public class ModifiersEffect {
    private static final int[] covenToMaxStrength = new int[]{1, 1, 2, 2, 3, 3, 4};
    public final EffectLevelCounter effectLevel;
    public final double powerScalingFactor;
    public final double durationScalingFactor;
    public final boolean isGlancing;
    public final Vec3d impactLocation;
    public final boolean ritualised;
    public final int covenSize;
    public final EntityPlayer caster;
    public UpgradableModifier strength = new UpgradableModifier(this);
    public UpgradableModifier duration = new UpgradableModifier(this);
    public int strengthPenalty;
    public boolean noParticles;
    public boolean inverted;
    public boolean disableBlockTarget;
    public boolean disableEntityTarget;
    public boolean strengthCeilingDisabled;
    public boolean powerCeilingDisabled;
    public boolean protectedFromNegativePotions;

    public ModifiersEffect(double powerScalingFactor, double durationScalingFactor, boolean glancing, Vec3d position, boolean ritualised, int covenSize, EntityPlayer caster) {
        this.effectLevel = new EffectLevelCounter();
        this.powerScalingFactor = powerScalingFactor;
        this.durationScalingFactor = durationScalingFactor;
        this.isGlancing = glancing;
        this.impactLocation = position;
        this.ritualised = ritualised;
        this.caster = caster;
        this.covenSize = covenSize;
    }

    public ModifiersEffect(double powerScalingFactor, double durationScalingFactor, boolean glancing, Vec3d position, ModifiersImpact impactModifiers) {
        this(powerScalingFactor, durationScalingFactor, glancing, position, impactModifiers.ritualised, impactModifiers.covenSize, impactModifiers.thrower);
    }

    public int getStrength() {
        if (this.ritualised) {
            return Math.min(Math.max(this.strength.getValue() - this.strengthPenalty, 0), covenToMaxStrength[Math.min(this.covenSize, covenToMaxStrength.length - 1)]);
        }
        return Math.max(this.strength.getValue() - this.strengthPenalty, 0);
    }

    public int getModifiedDuration(int ticks) {
        return Math.min(MathHelper.ceil((double)(this.durationScalingFactor * (double)ticks * (double)(this.duration.getValue() + 1))), Integer.MAX_VALUE);
    }

    public void reset() {
        this.inverted = false;
        this.strength.setValue(0);
        this.duration.setValue(0);
        this.noParticles = false;
    }
}

