/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.msrandom.witchery.block.entity.TileEntityMovingBrew;
import net.msrandom.witchery.brewing.Dispersal;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.RitualStatus;
import net.msrandom.witchery.entity.EntityDroplet;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.util.BlockUtil;

public class LiquidDispersal
extends Dispersal {
    @Override
    public void onImpactSplashPotion(World world, NBTTagCompound nbtBrew, RayTraceResult mop, ModifiersImpact modifiers) {
        boolean replaceable;
        BlockPos coord;
        if (mop != null) {
            switch (mop.typeOfHit) {
                case BLOCK: {
                    coord = mop.getBlockPos().offset(mop.sideHit);
                    break;
                }
                case ENTITY: {
                    coord = mop.entityHit.getPosition();
                    break;
                }
                default: {
                    coord = new BlockPos(modifiers.impactPosition);
                    break;
                }
            }
        } else {
            coord = new BlockPos(modifiers.impactPosition);
        }
        if (replaceable = BlockUtil.isReplaceableBlock(world, coord, (EntityLivingBase)modifiers.thrower)) {
            world.setBlockState(coord, WitcheryBlocks.BREW_LIQUID.getDefaultState());
            TileEntityMovingBrew gas = (TileEntityMovingBrew)world.getTileEntity(coord);
            if (gas != null) {
                gas.initialize(modifiers, nbtBrew);
            }
        }
    }

    @Override
    public RitualStatus onUpdateRitual(World world, BlockPos pos, NBTTagCompound nbtBrew, ModifiersRitual modifiers, ModifiersImpact impactModifiers) {
        int maxQuantity;
        WorldServer targetWorld = world.getMinecraftServer().getWorld(modifiers.getDimension());
        int radius = maxQuantity = 16 + 8 * impactModifiers.extent.get();
        int halfQuantity = maxQuantity / 4;
        int height2 = 100;
        double RSQ = radius * radius;
        int quantity = halfQuantity + world.rand.nextInt(halfQuantity);
        for (int i = 0; i < quantity; ++i) {
            int z;
            int y;
            int x = pos.getX() - radius + world.rand.nextInt(2 * radius);
            if (!(pos.distanceSq((double)x, (double)(y = height2 + world.rand.nextInt(20)), (double)(z = pos.getZ() - radius + world.rand.nextInt(2 * radius))) <= RSQ)) continue;
            targetWorld.spawnEntity((Entity)new EntityDroplet((World)targetWorld, x, y, z, nbtBrew));
        }
        return RitualStatus.success(modifiers.pulses >= 10 + impactModifiers.lifetime.get() * 5);
    }
}

