/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing;

import java.util.List;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.msrandom.witchery.brewing.Dispersal;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.RitualStatus;
import net.msrandom.witchery.init.data.brewing.WitcheryBrewEffects;

public class InstantDispersal
extends Dispersal {
    @Override
    public void onImpactSplashPotion(World world, NBTTagCompound nbtBrew, RayTraceResult mop, ModifiersImpact modifiers) {
        double R = 3 + modifiers.extent.get();
        double R_SQ = R * R;
        Vec3d position = modifiers.impactPosition;
        AxisAlignedBB bb = new AxisAlignedBB(position.x - R, position.y - R, position.z - R, position.x + R, position.y + R, position.z + R);
        List list1 = world.getEntitiesWithinAABB(EntityLivingBase.class, bb);
        for (EntityLivingBase targetEntity : list1) {
            double distanceSq = RangesKt.coerceAtMost((double)targetEntity.getDistanceSq(position.x, position.y, position.z), (double)R_SQ);
            boolean directHit = targetEntity == mop.entityHit;
            double effectScalingFactor = directHit ? 1.0 : 1.0 - Math.sqrt(distanceSq) / R;
            WitcheryBrewEffects.applyToEntity(world, targetEntity, nbtBrew, new ModifiersEffect(effectScalingFactor, 0.5 * effectScalingFactor, !directHit, position, modifiers));
        }
        if (mop.typeOfHit == RayTraceResult.Type.BLOCK) {
            WitcheryBrewEffects.applyToBlock(world, mop.getBlockPos(), mop.sideHit, MathHelper.ceil((double)R), nbtBrew, new ModifiersEffect(1.0, 1.0, false, position, modifiers));
        }
    }

    @Override
    public RitualStatus onUpdateRitual(World world, BlockPos pos, NBTTagCompound nbtBrew, ModifiersRitual modifiers, ModifiersImpact impactModifiers) {
        BlockPos target = modifiers.getTarget();
        ModifiersEffect effectModifiers = new ModifiersEffect(1.0, 1.0, false, new Vec3d((Vec3i)target), true, modifiers.covenSize, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)));
        WitcheryBrewEffects.applyRitualToBlock(world, target, EnumFacing.UP, 3 + impactModifiers.extent.get(), nbtBrew, modifiers, effectModifiers);
        return modifiers.getRitualStatus();
    }
}

