/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.msrandom.witchery.block.entity.TileEntityMovingBrew;
import net.msrandom.witchery.brewing.Dispersal;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.RitualStatus;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.data.brewing.WitcheryBrewEffects;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.BlockActionCircle;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.EntityUtil;

public class GasDispersal
extends Dispersal {
    @Override
    public void onImpactSplashPotion(World world, NBTTagCompound nbtBrew, RayTraceResult mop, ModifiersImpact modifiers) {
        boolean replaceable;
        BlockPos coord;
        if (mop != null) {
            switch (mop.typeOfHit) {
                case BLOCK: {
                    coord = mop.getBlockPos().offset(mop.sideHit);
                    break;
                }
                case ENTITY: {
                    coord = mop.entityHit.getPosition();
                    break;
                }
                default: {
                    coord = new BlockPos(modifiers.impactPosition);
                    break;
                }
            }
        } else {
            coord = new BlockPos(modifiers.impactPosition);
        }
        if (replaceable = BlockUtil.isReplaceableBlock(world, coord, (EntityLivingBase)modifiers.thrower)) {
            world.setBlockState(coord, WitcheryBlocks.BREW_GAS.getDefaultState());
            TileEntityMovingBrew gas = (TileEntityMovingBrew)world.getTileEntity(coord);
            if (gas != null) {
                gas.initialize(modifiers, nbtBrew);
            }
        }
    }

    @Override
    public RitualStatus onUpdateRitual(World world, BlockPos pos, final NBTTagCompound nbtBrew, final ModifiersRitual modifiers, ModifiersImpact impactModifiers) {
        BlockPos target = modifiers.getTarget();
        WorldServer targetWorld = world.getMinecraftServer().getWorld(modifiers.getDimension());
        final int height2 = 8;
        new BlockActionCircle(){

            @Override
            public void onBlock(World world, BlockPos pos) {
                BlockPos coords = null;
                for (int i = 0; i < height2; ++i) {
                    if (world.getBlockState(pos.up(i)).getMaterial() != Material.AIR && world.isAirBlock(pos.up(i + 1))) {
                        coords = pos;
                        break;
                    }
                    if (i <= 0 || world.getBlockState(pos.down(i)).getMaterial() == Material.AIR || !world.isAirBlock(pos.down(i - 1))) continue;
                    coords = pos;
                    break;
                }
                if (coords != null) {
                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)coords.getX() + 0.5, (double)(coords.getY() + 1), (double)coords.getZ() + 0.5, 1.0f, 1.0f, EnumParticleTypes.SPELL), world, coords.up(), 16.0);
                    FakePlayer player = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
                    ModifiersEffect effectModifiers = new ModifiersEffect(0.0, 1.0, false, new Vec3d((Vec3i)coords), true, modifiers.covenSize, (EntityPlayer)player);
                    if (world.rand.nextDouble() < 0.01) {
                        WitcheryBrewEffects.applyToBlock(world, coords, EnumFacing.UP, 1, nbtBrew, effectModifiers);
                    }
                    List<EntityLivingBase> entities = EntityUtil.getEntitiesInRadius(EntityLivingBase.class, world, coords.getX(), coords.getY(), coords.getZ(), 1.5);
                    for (EntityLivingBase entity : entities) {
                        effectModifiers = new ModifiersEffect(1.0, 1.0, false, new Vec3d((Vec3i)coords), true, modifiers.covenSize, (EntityPlayer)player);
                        WitcheryBrewEffects.applyToEntity(world, entity, nbtBrew, effectModifiers);
                    }
                }
            }
        }.processHollowCircle((World)targetWorld, target, modifiers.pulses);
        return RitualStatus.success(modifiers.pulses >= 8 + impactModifiers.extent.get() * 8);
    }
}

