/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing;

public class EffectLevelCounter {
    private int maxLevel;
    private int currentLevel;
    private int effects;

    public void increaseAvailableLevelIf(int incement, int ceilingLevel) {
        if (this.maxLevel < ceilingLevel) {
            this.maxLevel += incement;
        }
    }

    public int remainingCapacity() {
        return this.maxLevel - this.currentLevel;
    }

    public int usedCapacity() {
        return this.currentLevel;
    }

    public int getCount() {
        return this.effects;
    }

    public boolean tryConsumeLevel(int level) {
        if (this.canConsumeLevel(level)) {
            this.currentLevel += level;
            ++this.effects;
            return true;
        }
        return false;
    }

    public boolean canConsumeLevel(int level) {
        return level + this.currentLevel <= this.maxLevel;
    }

    public boolean hasEffects() {
        return this.currentLevel > 0;
    }

    public boolean canIncreasePlayerSkill(int currentSkillLevel) {
        if (this.currentLevel > this.maxLevel || this.maxLevel == 0) {
            return false;
        }
        if (currentSkillLevel < 30) {
            return this.maxLevel > 1 && this.currentLevel > 1;
        }
        if (currentSkillLevel < 60) {
            return this.maxLevel >= 4 && this.currentLevel >= 4;
        }
        if (currentSkillLevel < 90) {
            return this.maxLevel >= 6 && this.currentLevel >= 6;
        }
        return currentSkillLevel != 100 && this.maxLevel >= 8 && this.currentLevel >= 8;
    }

    public void reset() {
        this.maxLevel = 0;
        this.currentLevel = 0;
        this.effects = 0;
    }
}

