/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing;

import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.brewing.BrewNameBuilder;

public class BrewNamePart {
    public final String resource;
    public final String invertedResource;
    protected final String text;
    protected final String invertedText;
    protected final Position position;
    protected long baseDuration;
    protected long invertedDuration;

    public BrewNamePart(String resourceId) {
        this(resourceId, resourceId, Position.NONE);
    }

    public BrewNamePart(String resourceId, Position position) {
        this(resourceId, resourceId, position);
    }

    public BrewNamePart(String resourceId, String invertedResourceId) {
        this(resourceId, invertedResourceId, Position.NONE);
    }

    public BrewNamePart(String resourceId, String invertedResourceId, Position position) {
        this.resource = resourceId;
        this.invertedResource = invertedResourceId;
        this.text = WitcheryResurrected.translate(resourceId, new Object[0]);
        this.invertedText = WitcheryResurrected.translate(invertedResourceId, new Object[0]);
        this.position = position;
    }

    public void applyTo(BrewNameBuilder nameBuilder) {
        switch (this.position) {
            case NONE: {
                nameBuilder.append(this.text, this.invertedText, this.baseDuration);
                break;
            }
            case PREFIX: {
                nameBuilder.appendPrefix(this.text);
                break;
            }
            case POSTFIX: {
                nameBuilder.appendPostfix(this.text);
            }
        }
    }

    public BrewNamePart setBaseDuration(long baseDuration, long invertedDuration) {
        this.baseDuration = baseDuration;
        this.invertedDuration = invertedDuration;
        return this;
    }

    public BrewNamePart setBaseDuration(int baseDuration) {
        return this.setBaseDuration(baseDuration, baseDuration);
    }

    public static enum Position {
        NONE,
        PREFIX,
        POSTFIX;

    }
}

