/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityGoblin;
import net.msrandom.witchery.entity.EntityGoblinGulg;
import net.msrandom.witchery.entity.EntityGoblinMog;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntityWorshipStatue
extends WitcheryTileEntity {
    private UUID owner;
    private EntityPlayer player;

    public void setOwner(EntityPlayer player) {
        this.owner = player.getUniqueID();
        this.player = player;
        if (!this.world.isRemote) {
            BlockUtil.notifyBlockUpdate(this.world, this.getPos());
        }
    }

    public void setOwnerId(UUID player) {
        this.owner = player;
        if (this.hasWorld() && !this.world.isRemote) {
            BlockUtil.notifyBlockUpdate(this.world, this.getPos());
        }
    }

    public UUID getOwnerId() {
        return this.owner;
    }

    public EntityPlayer getOwner() {
        return this.getOwner(this.world);
    }

    public EntityPlayer getOwner(World world) {
        World world2 = world = world == null ? this.world : world;
        if (world != null && this.player == null) {
            this.player = WitcheryUtils.getPlayer(world, this.owner);
            return this.player;
        }
        return this.player;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        if (this.owner != null) {
            nbtRoot.setUniqueId("Owner", this.owner);
        }
        return nbtRoot;
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        if (nbtRoot.hasUniqueId("Owner")) {
            this.owner = nbtRoot.getUniqueId("Owner");
        }
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 1, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.handleUpdateTag(packet2.getNbtCompound());
        this.world.markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public int updateWorshippersAndGetLevel() {
        double R = 8.0;
        AxisAlignedBB bb = new AxisAlignedBB((double)this.getPos().getX() + 0.5 - R, (double)this.getPos().getY() + 0.5 - R, (double)this.getPos().getZ() + 0.5 - R, (double)this.getPos().getX() + 0.5 + R, (double)this.getPos().getY() + 0.5 + R, (double)this.getPos().getZ() + 0.5 + R);
        List entities = this.world.getEntitiesWithinAABB(EntityGoblin.class, bb);
        int worshipCount = 0;
        for (EntityGoblin goblin : entities) {
            if (goblin.isWorshipping()) {
                ++worshipCount;
                continue;
            }
            goblin.beginWorship(this);
        }
        return worshipCount;
    }

    @Override
    public void update() {
        super.update();
        if (!this.world.isRemote && this.hasOwner() && this.ticks % 100L == 0L) {
            int worshipCount = this.updateWorshippersAndGetLevel();
            EntityPlayer player = this.getOwner();
            if (player != null) {
                int maxEnergy;
                int currentEnergy;
                player.getEntityData();
                if (worshipCount >= 5 && player.getDistanceSq(this.getPos()) <= 4096.0 && (currentEnergy = Infusion.getCurrentEnergy(player)) < (maxEnergy = Infusion.getMaxEnergy(player))) {
                    Infusion.setCurrentEnergy(player, Math.min(currentEnergy + 30, maxEnergy));
                    player.playSound(SoundEvents.BLOCK_NOTE_PLING, 0.5f, 0.4f / (player.getRNG().nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY, player.posZ, 1.0f, 2.0f, EnumParticleTypes.SPELL_INSTANT), (Entity)player);
                }
                if (worshipCount >= 10) {
                    PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                    playerEx.addWorship(worshipCount >= 15 ? 1 : 0);
                }
                if (worshipCount >= 15 && WitcheryConfigOptions.hobgoblinGodSpawnChance > 0 && this.world.rand.nextDouble() < (double)WitcheryConfigOptions.hobgoblinGodSpawnChance * 1.0E-4) {
                    this.summonGoblinGods(player, 64.0, 16);
                }
            }
        }
    }

    public boolean summonGoblinGods(EntityPlayer player, double detectDistance, int spawnDistance) {
        EntityCreature mog;
        BlockPos pos = this.getPos();
        AxisAlignedBB bb2 = new AxisAlignedBB(pos.add(-detectDistance, -detectDistance, -detectDistance), pos.add(detectDistance, detectDistance, detectDistance));
        if (this.world.getEntitiesWithinAABB(EntityGoblinMog.class, bb2).size() == 0 && this.world.getEntitiesWithinAABB(EntityGoblinGulg.class, bb2).size() == 0 && (mog = Infusion.spawnCreature(this.world, EntityGoblinMog.class, pos, (EntityLivingBase)player, 0, spawnDistance, EnumParticleTypes.FLAME, SoundEvents.ENTITY_WITHER_SPAWN)) != null) {
            mog.onInitialSpawn(this.world.getDifficultyForLocation(mog.getPosition()), null);
            mog.setAttackTarget((EntityLivingBase)player);
            EntityGoblinGulg gulg = new EntityGoblinGulg(this.world);
            gulg.setLocationAndAngles(mog.posX, mog.posY, mog.posZ, 0.0f, 0.0f);
            this.world.spawnEntity((Entity)gulg);
            gulg.onInitialSpawn(this.world.getDifficultyForLocation(mog.getPosition()), null);
            gulg.setAttackTarget((EntityLivingBase)player);
            return true;
        }
        return false;
    }
}

