/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockFumeFunnel;
import net.msrandom.witchery.block.BlockWitchesOven;
import net.msrandom.witchery.brewing.ItemKey;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryWoodTypes;
import net.msrandom.witchery.init.items.WitcheryFumeItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.integration.IntegrationManager;

public class TileEntityWitchesOven
extends TileEntity
implements ISidedInventory,
ITickable {
    static final int COOK_TIME = 180;
    private static final double FUNNEL_CHANCE = 0.25;
    private static final double FILTERED_FUNNEL_CHANCE = 0.3;
    private static final double DOUBLED_FILTERED_FUNNEL_CHANCE = 0.8;
    public static final int SLOT_TO_COOK = 0;
    public static final int SLOT_JARS = 1;
    public static final int SLOT_FUEL = 2;
    public static final int SLOT_COOKED = 3;
    public static final int SLOT_BY_PRODUCT = 4;
    private static final int[] SLOTS_TOPS = new int[]{0, 1};
    private static final int[] SLOTS_BOTTOM = new int[]{1, 2};
    private static final int[] SLOTS_SIDES = new int[]{4, 3, 1, 2};
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);

    public int getSizeInventory() {
        return this.furnaceItemStacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.furnaceItemStacks) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getStackInSlot(int par1) {
        return (ItemStack)this.furnaceItemStacks.get(par1);
    }

    public ItemStack decrStackSize(int par1, int par2) {
        return ItemStackHelper.getAndSplit(this.furnaceItemStacks, (int)par1, (int)par2);
    }

    public ItemStack removeStackFromSlot(int par1) {
        return ItemStackHelper.getAndRemove(this.furnaceItemStacks, (int)par1);
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(index);
        boolean flag = !stack.isEmpty() && stack.isItemEqual(itemstack) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)itemstack);
        this.furnaceItemStacks.set(index, (Object)stack);
        if (stack.getCount() > this.getInventoryStackLimit()) {
            stack.setCount(this.getInventoryStackLimit());
        }
        if (index == 0 && !flag) {
            this.totalCookTime = this.getCookTime();
            this.cookTime = 0;
            this.markDirty();
        }
    }

    public String getName() {
        return this.getBlockType().getLocalizedName();
    }

    public boolean hasCustomName() {
        return true;
    }

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.getTagList("Items", 10);
        this.furnaceItemStacks = NonNullList.withSize((int)this.getSizeInventory(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
            byte b0 = nbttagcompound1.getByte("Slot");
            if (b0 < 0 || b0 >= this.furnaceItemStacks.size()) continue;
            this.furnaceItemStacks.set((int)b0, (Object)new ItemStack(nbttagcompound1));
        }
        this.furnaceBurnTime = par1NBTTagCompound.getInteger("BurnTime");
        this.cookTime = par1NBTTagCompound.getInteger("CookTime");
        this.totalCookTime = par1NBTTagCompound.getInteger("CookTimeTotal");
        this.currentItemBurnTime = TileEntityFurnace.getItemBurnTime((ItemStack)((ItemStack)this.furnaceItemStacks.get(1)));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("BurnTime", this.furnaceBurnTime);
        par1NBTTagCompound.setInteger("CookTime", this.cookTime);
        par1NBTTagCompound.setInteger("CookTimeTotal", this.totalCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            if (((ItemStack)this.furnaceItemStacks.get(i)).isEmpty()) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            ((ItemStack)this.furnaceItemStacks.get(i)).writeToNBT(nbttagcompound1);
            nbttaglist.appendTag((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.setTag("Items", (NBTBase)nbttaglist);
        return par1NBTTagCompound;
    }

    @Nonnull
    public ITextComponent getDisplayName() {
        return new TextComponentString(this.getName());
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.cookTime * par1 / this.getCookTime();
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * par1 / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void update() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.world.isRemote) {
            ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(2);
            if (this.isBurning() || !itemstack.isEmpty() && !((ItemStack)this.furnaceItemStacks.get(0)).isEmpty()) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.getItemBurnTime((ItemStack)itemstack);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!itemstack.isEmpty()) {
                            Item item = itemstack.getItem();
                            itemstack.shrink(1);
                            if (itemstack.isEmpty()) {
                                ItemStack item1 = item.getContainerItem(itemstack);
                                this.furnaceItemStacks.set(2, (Object)item1);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime();
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.clamp((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                BlockWitchesOven.updateWitchesOvenBlockState(this.isBurning(), this.world, this.pos);
            }
        }
        if (flag1) {
            this.markDirty();
        }
    }

    private boolean canSmelt() {
        if (((ItemStack)this.furnaceItemStacks.get(0)).isEmpty()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.instance().getSmeltingResult((ItemStack)this.furnaceItemStacks.get(0));
        if (itemstack.isEmpty()) {
            return false;
        }
        Item item = itemstack.getItem();
        if (item != Items.COAL && !(item instanceof ItemFood) && itemstack.getItem() != WitcheryIngredientItems.WOOD_ASH) {
            return false;
        }
        if (((ItemStack)this.furnaceItemStacks.get(3)).isEmpty()) {
            return true;
        }
        if (!((ItemStack)this.furnaceItemStacks.get(3)).isItemEqual(itemstack)) {
            return false;
        }
        int result2 = ((ItemStack)this.furnaceItemStacks.get(3)).getCount() + itemstack.getCount();
        return result2 <= this.getInventoryStackLimit() && result2 <= itemstack.getMaxStackSize();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.instance().getSmeltingResult((ItemStack)this.furnaceItemStacks.get(0));
            if (((ItemStack)this.furnaceItemStacks.get(3)).isEmpty()) {
                this.furnaceItemStacks.set(3, (Object)itemstack.copy());
            } else if (((ItemStack)this.furnaceItemStacks.get(3)).getItem() == itemstack.getItem()) {
                ItemStack itemStack = (ItemStack)this.furnaceItemStacks.get(3);
                itemStack.grow(itemstack.getCount());
            }
            this.generateByProduct();
            ItemStack itemStack2 = (ItemStack)this.furnaceItemStacks.get(0);
            itemStack2.shrink(1);
        }
    }

    private int getFumeFunnels() {
        int funnels = 0;
        EnumFacing facing = (EnumFacing)this.world.getBlockState(this.getPos()).getValue((IProperty)BlockWitchesOven.FACING);
        switch (facing) {
            case NORTH: 
            case SOUTH: {
                funnels += this.isFumeFunnel(this.getPos().west(), facing) ? 1 : 0;
                funnels += this.isFumeFunnel(this.getPos().east(), facing) ? 1 : 0;
                break;
            }
            case WEST: 
            case EAST: {
                funnels += this.isFumeFunnel(this.getPos().north(), facing) ? 1 : 0;
                funnels += this.isFumeFunnel(this.getPos().south(), facing) ? 1 : 0;
            }
        }
        return funnels += this.isFumeFunnel(this.getPos().up(), facing) ? 1 : 0;
    }

    private boolean isFumeFunnel(BlockPos pos, EnumFacing facing) {
        IBlockState state = this.world.getBlockState(pos);
        Block block = state.getBlock();
        return (block == WitcheryBlocks.FUME_FUNNEL || block == WitcheryBlocks.FILTERED_FUME_FUNNEL) && state.getValue((IProperty)BlockWitchesOven.FACING) == facing;
    }

    private double getFumeFunnelsChance() {
        double funnels = 0.0;
        switch ((EnumFacing)this.world.getBlockState(this.getPos()).getValue((IProperty)BlockWitchesOven.FACING)) {
            case NORTH: {
                funnels += this.getFumeFunnelChance(this.getPos().east(), EnumFacing.NORTH);
                funnels += this.getFumeFunnelChance(this.getPos().west(), EnumFacing.NORTH);
                break;
            }
            case SOUTH: {
                funnels += this.getFumeFunnelChance(this.getPos().east(), EnumFacing.SOUTH);
                funnels += this.getFumeFunnelChance(this.getPos().west(), EnumFacing.SOUTH);
                break;
            }
            case WEST: {
                funnels += this.getFumeFunnelChance(this.getPos().south(), EnumFacing.WEST);
                funnels += this.getFumeFunnelChance(this.getPos().north(), EnumFacing.WEST);
                break;
            }
            case EAST: {
                funnels += this.getFumeFunnelChance(this.getPos().south(), EnumFacing.EAST);
                funnels += this.getFumeFunnelChance(this.getPos().north(), EnumFacing.EAST);
            }
        }
        return funnels;
    }

    private double getFumeFunnelChance(BlockPos pos, EnumFacing facing) {
        IBlockState state = this.world.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof BlockFumeFunnel && state.getValue((IProperty)BlockWitchesOven.FACING) == facing) {
            if (((BlockFumeFunnel)block).isFiltered()) {
                return WitcheryConfigOptions.doubleFumeFilterChance ? 0.8 : 0.3;
            }
            return 0.25;
        }
        return 0.0;
    }

    private int getCookTime() {
        return 180 - 20 * this.getFumeFunnels();
    }

    private void generateByProduct() {
        double funnels = this.getFumeFunnelsChance();
        if (this.world.rand.nextDouble() <= Math.min(0.3 + funnels, 1.0) && !((ItemStack)this.furnaceItemStacks.get(1)).isEmpty()) {
            ItemStack slot = (ItemStack)this.furnaceItemStacks.get(0);
            Item byProduct = WitcheryWoodTypes.getSaplingFumes().get(ItemKey.fromStack(slot));
            if (byProduct == null) {
                Item moddedByProduct = IntegrationManager.getByProduct(slot);
                this.createByProduct(new ItemStack(moddedByProduct == null ? WitcheryFumeItems.FOUL_FUME : moddedByProduct));
            } else {
                this.createByProduct(new ItemStack(byProduct));
            }
        }
    }

    private void createByProduct(ItemStack byProduct) {
        int BY_PRODUCT_INDEX = 4;
        if (((ItemStack)this.furnaceItemStacks.get(BY_PRODUCT_INDEX)).isEmpty()) {
            this.furnaceItemStacks.set(BY_PRODUCT_INDEX, (Object)byProduct);
            ItemStack itemStack = (ItemStack)this.furnaceItemStacks.get(1);
            itemStack.shrink(1);
        } else if (((ItemStack)this.furnaceItemStacks.get(BY_PRODUCT_INDEX)).isItemEqual(byProduct) && ((ItemStack)this.furnaceItemStacks.get(BY_PRODUCT_INDEX)).getCount() + byProduct.getCount() < ((ItemStack)this.furnaceItemStacks.get(BY_PRODUCT_INDEX)).getMaxStackSize()) {
            ItemStack itemStack2 = (ItemStack)this.furnaceItemStacks.get(BY_PRODUCT_INDEX);
            itemStack2.grow(byProduct.getCount());
            ItemStack itemStack3 = (ItemStack)this.furnaceItemStacks.get(1);
            itemStack3.shrink(1);
        }
    }

    public boolean isUsableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.world.getTileEntity(this.getPos()) == this && par1EntityPlayer.getDistanceSq(this.getPos()) <= 64.0;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        if (slot == 3 || slot == 4) {
            return false;
        }
        if (slot == 2) {
            return TileEntityFurnace.isItemFuel((ItemStack)itemstack);
        }
        if (slot == 1) {
            return itemstack.getItem() == WitcheryFumeItems.CLAY_JAR;
        }
        return slot != 0 || itemstack.getItem() != WitcheryFumeItems.CLAY_JAR;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.cookTime;
            }
            case 1: {
                return this.furnaceBurnTime;
            }
            case 2: {
                return this.currentItemBurnTime;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.cookTime = value;
                break;
            }
            case 1: {
                this.furnaceBurnTime = value;
                break;
            }
            case 2: {
                this.currentItemBurnTime = value;
            }
        }
    }

    public int getFieldCount() {
        return 3;
    }

    public void clear() {
        this.furnaceItemStacks.clear();
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOPS : SLOTS_SIDES);
    }

    public boolean canInsertItem(int slot, ItemStack itemstack, EnumFacing par3) {
        return this.isItemValidForSlot(slot, itemstack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, EnumFacing side) {
        if (side == EnumFacing.UP) {
            return false;
        }
        if (side == EnumFacing.DOWN) {
            return slot == 1 && stack.getItem() == Items.BUCKET;
        }
        return slot == 3 || slot == 2;
    }
}

