/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.common.INullSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.init.WitcheryBlocks;

public class TileEntityVoidBramble
extends WitcheryTileEntity
implements INullSource {
    private static final String OWNER_KEY = "WitcheryPlacer";
    private String owner;

    @Override
    public boolean isPowerInvalid() {
        return this.isInvalid();
    }

    @Override
    protected void initiate() {
        super.initiate();
        if (!this.world.isRemote && this.world.getBlockState(this.getPos()).getBlock() == WitcheryBlocks.VOID_BRAMBLE) {
            PowerSources.instance().registerNullSource(this);
        }
    }

    public void invalidate() {
        super.invalidate();
        if (!this.world.isRemote) {
            PowerSources.instance().removeNullSource(this);
        }
    }

    public String getOwner() {
        return this.owner != null ? this.owner : "";
    }

    public void setOwner(String username) {
        this.owner = username;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtTag) {
        super.writeToNBT(nbtTag);
        nbtTag.setString(OWNER_KEY, this.getOwner());
        return nbtTag;
    }

    public void readFromNBT(NBTTagCompound nbtTag) {
        super.readFromNBT(nbtTag);
        this.owner = nbtTag.hasKey(OWNER_KEY) ? nbtTag.getString(OWNER_KEY) : "";
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.getPos(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.handleUpdateTag(packet2.getNbtCompound());
    }

    @Override
    public World getCurrentWorld() {
        return this.world;
    }

    @Override
    public BlockPos getLocation() {
        return this.getPos();
    }

    @Override
    public float getRange() {
        return 32.0f;
    }
}

