/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityAltar;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.recipe.SpinningWheelRecipe;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntitySpinningWheel
extends TileEntity
implements ISidedInventory,
ITickable {
    static final float POWER_PER_TICK = 0.6f;
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{3, 1, 2};
    private static final int[] SLOTS_SIDES = new int[]{2, 4, 3, 1};
    public int furnaceCookTime;
    public int powerLevel;
    BlockPos powerSourceCoord;
    private NonNullList<ItemStack> slots = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
    public int prevTicks;
    public int ticks;

    public int getSizeInventory() {
        return this.slots.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.slots) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.slots.get(slot);
    }

    public ItemStack decrStackSize(int slot, int quantity) {
        return ItemStackHelper.getAndSplit(this.slots, (int)slot, (int)quantity);
    }

    public ItemStack removeStackFromSlot(int slot) {
        return ItemStackHelper.getAndRemove(this.slots, (int)slot);
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.slots.set(slot, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getInventoryStackLimit()) {
            stack.setCount(this.getInventoryStackLimit());
        }
    }

    public String getName() {
        return this.getBlockType().getLocalizedName();
    }

    public boolean hasCustomName() {
        return true;
    }

    @Nonnull
    public ITextComponent getDisplayName() {
        return new TextComponentString(this.getName());
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        NBTTagList nbtSlotList = nbtRoot.getTagList("Items", 10);
        this.slots = NonNullList.withSize((int)this.getSizeInventory(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nbtSlotList.tagCount(); ++i) {
            NBTTagCompound nbtSlot = nbtSlotList.getCompoundTagAt(i);
            byte b0 = nbtSlot.getByte("Slot");
            if (b0 < 0 || b0 >= this.slots.size()) continue;
            this.slots.set((int)b0, (Object)new ItemStack(nbtSlot));
        }
        this.furnaceCookTime = nbtRoot.getShort("CookTime");
        this.powerLevel = nbtRoot.getShort("PowerLevel");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        nbtRoot.setShort("CookTime", (short)this.furnaceCookTime);
        nbtRoot.setShort("PowerLevel", (short)this.powerLevel);
        NBTTagList nbtSlotList = new NBTTagList();
        for (int i = 0; i < this.slots.size(); ++i) {
            if (((ItemStack)this.slots.get(i)).isEmpty()) continue;
            NBTTagCompound nbtSlot = new NBTTagCompound();
            nbtSlot.setByte("Slot", (byte)i);
            ((ItemStack)this.slots.get(i)).writeToNBT(nbtSlot);
            nbtSlotList.appendTag((NBTBase)nbtSlot);
        }
        nbtRoot.setTag("Items", (NBTBase)nbtSlotList);
        return nbtRoot;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.furnaceCookTime * par1 / this.getTotalCookTime();
    }

    public int getTotalCookTime() {
        return 300;
    }

    public int getCookTime() {
        return this.furnaceCookTime;
    }

    IPowerSource getPowerSource() {
        if (this.powerSourceCoord == null || (long)(this.ticks % 100) == 0L) {
            return this.findNewPowerSource();
        }
        TileEntity tileEntity = this.world.getTileEntity(this.powerSourceCoord);
        if (!(tileEntity instanceof TileEntityAltar)) {
            return this.findNewPowerSource();
        }
        TileEntityAltar altarTileEntity = (TileEntityAltar)tileEntity;
        if (!altarTileEntity.isValid()) {
            return this.findNewPowerSource();
        }
        return altarTileEntity;
    }

    private IPowerSource findNewPowerSource() {
        List<PowerSources.RelativePowerSource> sources = PowerSources.instance().get(this.world, this.pos);
        return sources != null && !sources.isEmpty() ? sources.get(0).source() : null;
    }

    public void update() {
        boolean update = false;
        if (!this.world.isRemote) {
            boolean powered;
            boolean bl = powered = this.powerLevel > 0;
            if (this.getRecipe() != null) {
                IPowerSource powerSource = this.getPowerSource();
                this.powerSourceCoord = powerSource != null && powerSource.isLocationEqual(this.powerSourceCoord) ? powerSource.getLocation() : null;
                int n = this.powerLevel = powerSource != null ? 1 : 0;
                if (powerSource != null && powerSource.consumePower(0.6f)) {
                    update = this.furnaceCookTime == 0;
                    ++this.furnaceCookTime;
                    if (this.furnaceCookTime == this.getTotalCookTime()) {
                        this.furnaceCookTime = 0;
                        this.processItem();
                        update = true;
                    }
                    if (powered != this.powerLevel > 0) {
                        update = true;
                    }
                } else {
                    this.powerLevel = 0;
                    if (powered) {
                        update = true;
                    }
                }
            } else {
                if ((long)(this.ticks % 40) == 0L) {
                    IPowerSource powerSource = this.getPowerSource();
                    if (powerSource != null && powerSource.isLocationEqual(this.powerSourceCoord)) {
                        this.powerSourceCoord = powerSource.getLocation();
                    }
                    int n = this.powerLevel = powerSource != null ? 1 : 0;
                }
                update = this.furnaceCookTime > 0 || powered != this.powerLevel > 0;
                this.furnaceCookTime = 0;
            }
        }
        if (update) {
            this.markDirty();
        }
        ++this.ticks;
    }

    public void markDirty() {
        super.markDirty();
        if (!this.world.isRemote) {
            BlockUtil.notifyBlockUpdate(this.world, this.getPos());
        }
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.getPos(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.readFromNBT(packet2.getNbtCompound());
        this.world.markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
    }

    private SpinningWheelRecipe getRecipe() {
        if (((ItemStack)this.slots.get(0)).isEmpty()) {
            return null;
        }
        Optional<SpinningWheelRecipe> recipe = WitcheryUtils.getRecipeManager(this.world).getRecipe(WitcheryRecipeTypes.SPINNING_WHEEL, this, this.world);
        if (!recipe.isPresent()) {
            return null;
        }
        if (((ItemStack)this.slots.get(4)).isEmpty()) {
            return recipe.get();
        }
        ItemStack itemstack = recipe.get().getResult();
        if (!((ItemStack)this.slots.get(4)).isItemEqual(itemstack)) {
            return null;
        }
        int result2 = ((ItemStack)this.slots.get(4)).getCount() + itemstack.getCount();
        return result2 <= this.getInventoryStackLimit() && result2 <= itemstack.getMaxStackSize() ? recipe.get() : null;
    }

    public void processItem() {
        SpinningWheelRecipe recipe = this.getRecipe();
        if (recipe != null) {
            ItemStack itemstack = recipe.getResult();
            if (((ItemStack)this.slots.get(4)).isEmpty()) {
                this.slots.set(4, (Object)itemstack.copy());
            } else if (((ItemStack)this.slots.get(4)).isItemEqual(itemstack)) {
                ItemStack itemStack = (ItemStack)this.slots.get(4);
                itemStack.grow(itemstack.getCount());
            }
            ItemStack itemStack2 = (ItemStack)this.slots.get(0);
            itemStack2.shrink(recipe.getFibreCount());
            for (int i = 1; i <= 3; ++i) {
                ItemStack stack = (ItemStack)this.slots.get(i);
                Item item = stack.getItem();
                stack.shrink(1);
                if (!itemstack.isEmpty()) continue;
                this.setInventorySlotContents(i, item.getContainerItem(itemstack));
            }
        }
    }

    public boolean isUsableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.world.getTileEntity(this.getPos()) == this && par1EntityPlayer.getDistanceSq(this.getPos()) <= 64.0;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        return slot != 4;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.furnaceCookTime;
            }
            case 1: {
                return this.powerLevel;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceCookTime = value;
                break;
            }
            case 1: {
                this.powerLevel = value;
            }
        }
    }

    public int getFieldCount() {
        return 2;
    }

    public void clear() {
        this.slots.clear();
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    public boolean canInsertItem(int slot, ItemStack itemstack, EnumFacing par3) {
        return this.isItemValidForSlot(slot, itemstack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, EnumFacing side) {
        return side != EnumFacing.UP && side != EnumFacing.DOWN && slot == 4;
    }
}

