/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.msrandom.witchery.util.BlockUtil;

public class TileEntitySilverVat
extends TileEntity
implements IInventory {
    private final int[] sides;
    public boolean reenterLock;
    private ItemStack item = ItemStack.EMPTY;

    public TileEntitySilverVat() {
        this.sides = new int[6];
    }

    public void notifyBlockUpdate(boolean notifyNeighbours) {
        BlockUtil.notifyBlockUpdate(this.world, this.getPos());
        if (notifyNeighbours && this.world != null) {
            this.world.notifyNeighborsRespectDebug(this.getPos(), this.getBlockType(), true);
        }
    }

    public int getSizeInventory() {
        return 1;
    }

    public boolean isEmpty() {
        return this.item.isEmpty();
    }

    public void setLastStackSizeForSide(EnumFacing side, int stackSize) {
        this.sides[side.getIndex()] = stackSize;
    }

    public int getLastStackSizeForSide(EnumFacing side) {
        return this.sides[side.getIndex()];
    }

    public ItemStack getStackInSlot(int slot) {
        return slot == 0 ? this.item : ItemStack.EMPTY;
    }

    public ItemStack decrStackSize(int slot, int quantity) {
        if (slot == 0) {
            if (this.item.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (this.item.getCount() <= quantity) {
                ItemStack itemstack = this.item.copy();
                this.item = ItemStack.EMPTY;
                return itemstack;
            }
            return this.item.splitStack(quantity);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeStackFromSlot(int slot) {
        if (slot == 0 && !this.item.isEmpty()) {
            ItemStack itemstack = this.item.copy();
            this.item = ItemStack.EMPTY;
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        if (slot == 0) {
            this.item = stack;
            if (!stack.isEmpty() && stack.getCount() > this.getInventoryStackLimit()) {
                stack.setCount(this.getInventoryStackLimit());
            }
        }
    }

    public String getName() {
        return this.getBlockType().getLocalizedName();
    }

    public boolean hasCustomName() {
        return true;
    }

    public ITextComponent getDisplayName() {
        return new TextComponentString(this.getName());
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        NBTTagCompound nbtSlot = nbtRoot.getCompoundTag("Item");
        this.item = new ItemStack(nbtSlot);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        NBTTagCompound nbtSlot = new NBTTagCompound();
        this.item.writeToNBT(nbtSlot);
        nbtRoot.setTag("Item", (NBTBase)nbtSlot);
        return nbtRoot;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
        super.markDirty();
        if (!this.world.isRemote) {
            BlockUtil.notifyBlockUpdate(this.world, this.getPos());
        }
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.getPos(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.readFromNBT(packet2.getNbtCompound());
        this.world.markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
    }

    public boolean isUsableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.world.getTileEntity(this.getPos()) == this && par1EntityPlayer.getDistanceSq(this.getPos()) <= 64.0;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        return false;
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
        this.item = ItemStack.EMPTY;
    }
}

