/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;

public class TileEntityRemovedBlock
extends WitcheryTileEntity {
    private IBlockState saved;
    private int timeout;

    @Override
    public void update() {
        super.update();
        if (!this.world.isRemote && this.ticks >= (long)this.timeout) {
            if (this.saved == null) {
                this.world.setBlockToAir(this.getPos());
            } else {
                this.world.setBlockState(this.getPos(), this.saved, 3);
            }
        }
    }

    public void saveBlock(int timeoutTicks, IBlockState block) {
        this.saved = block;
        this.timeout = timeoutTicks;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        nbtRoot.setInteger("Timeout", Math.max(this.timeout, 0));
        if (this.saved != null) {
            nbtRoot.setTag("Block", (NBTBase)NBTUtil.writeBlockState((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.saved));
        }
        return nbtRoot;
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.timeout = Math.max(nbtRoot.getInteger("Timeout"), 0);
        if (nbtRoot.hasKey("Block")) {
            this.saved = NBTUtil.readBlockState((NBTTagCompound)nbtRoot.getCompoundTag("Block"));
        }
    }
}

