/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.item.WitcheryPoppetItems;
import net.msrandom.witchery.util.BlockUtil;

public class TileEntityPoppetShelf
extends WitcheryTileEntity
implements IInventory {
    protected String customName;
    private NonNullList<ItemStack> contents = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private ForgeChunkManager.Ticket chunkTicket;

    @Override
    protected void initiate() {
        super.initiate();
        if (!this.world.isRemote && this.chunkTicket == null) {
            this.forceChunk();
        }
    }

    private void forceChunk() {
        this.chunkTicket = ForgeChunkManager.requestTicket((Object)WitcheryResurrected.instance, (World)this.world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        int x = this.getPos().getX();
        int y = this.getPos().getY();
        int z = this.getPos().getZ();
        if (this.chunkTicket != null) {
            this.chunkTicket.getModData().setInteger("poppetX", x);
            this.chunkTicket.getModData().setInteger("poppetY", y);
            this.chunkTicket.getModData().setInteger("poppetZ", z);
            this.setTicket(this.chunkTicket);
        }
    }

    public void setTicket(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)new ChunkPos(this.getPos()));
    }

    public void invalidate() {
        if (!this.world.isRemote && this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        }
        super.invalidate();
    }

    public int getSizeInventory() {
        return 9;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.contents) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.contents.get(slot);
    }

    public ItemStack decrStackSize(int slot, int size) {
        this.markDirty();
        return ItemStackHelper.getAndSplit(this.contents, (int)slot, (int)size);
    }

    public ItemStack removeStackFromSlot(int slot) {
        return ItemStackHelper.getAndRemove(this.contents, (int)slot);
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        this.contents.set(slot, (Object)itemstack);
        if (!itemstack.isEmpty() && itemstack.getCount() > this.getInventoryStackLimit()) {
            itemstack.setCount(this.getInventoryStackLimit());
        }
        this.markDirty();
    }

    public void markDirty() {
        BlockUtil.notifyBlockUpdate(this.world, this.getPos());
        super.markDirty();
    }

    public String getName() {
        return this.hasCustomName() ? this.customName : "container.witchery.poppet_shelf";
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 1, this.getUpdateTag());
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.handleUpdateTag(packet2.getNbtCompound());
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public ITextComponent getDisplayName() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public void readFromNBT(NBTTagCompound nbtTag) {
        super.readFromNBT(nbtTag);
        NBTTagList nbttaglist = nbtTag.getTagList("Items", 10);
        this.contents = NonNullList.withSize((int)this.getSizeInventory(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
            int j = nbttagcompound1.getByte("Slot") & 0xFF;
            if (j >= this.contents.size()) continue;
            this.contents.set(j, (Object)new ItemStack(nbttagcompound1));
        }
        if (nbtTag.hasKey("CustomName")) {
            this.customName = nbtTag.getString("CustomName");
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtTag) {
        super.writeToNBT(nbtTag);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.contents.size(); ++i) {
            if (((ItemStack)this.contents.get(i)).isEmpty()) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            ((ItemStack)this.contents.get(i)).writeToNBT(nbttagcompound1);
            nbttaglist.appendTag((NBTBase)nbttagcompound1);
        }
        nbtTag.setTag("Items", (NBTBase)nbttaglist);
        if (this.hasCustomName()) {
            nbtTag.setString("CustomName", this.customName);
        }
        return nbtTag;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.world.getTileEntity(this.getPos()) == this && player.getDistanceSq(this.getPos()) <= 64.0;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        return !itemstack.isEmpty() && itemstack.getItem() instanceof WitcheryPoppetItems.ItemPoppet;
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
        this.contents.clear();
    }
}

