/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.util.BlockUtil;

public class TileEntityMovingBrew
extends TileEntity {
    public NBTTagCompound nbtEffect;
    public BrewActionList actionList;
    public int duration;
    public int expansion;
    public int updateCount;
    public UUID thrower;
    private int runTicks;

    public void initialize(ModifiersImpact impactModifiers, NBTTagCompound nbtBrew) {
        if (nbtBrew != null) {
            this.nbtEffect = nbtBrew.copy();
            this.actionList = new BrewActionList(this.nbtEffect);
        }
        this.duration = impactModifiers.lifetime.get() >= 0 ? 5 + impactModifiers.lifetime.get() * impactModifiers.lifetime.get() * 5 : 100;
        this.expansion = Math.min(4 + impactModifiers.extent.get(), 10);
        if (impactModifiers.thrower != null) {
            this.thrower = impactModifiers.thrower.getUniqueID();
        }
        BlockUtil.notifyBlockUpdate(this.world, this.getPos());
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 1, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.readFromNBT(packet2.getNbtCompound());
        this.world.markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        if (this.nbtEffect != null) {
            nbtRoot.setTag("Effect", (NBTBase)this.nbtEffect);
        }
        nbtRoot.setInteger("Duration", this.duration);
        nbtRoot.setInteger("Expansion", this.expansion);
        if (this.thrower != null) {
            nbtRoot.setUniqueId("Thrower", this.thrower);
        }
        return nbtRoot;
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        if (nbtRoot.hasKey("Effect")) {
            this.nbtEffect = nbtRoot.getCompoundTag("Effect");
            this.actionList = new BrewActionList(this.nbtEffect);
        }
        this.duration = nbtRoot.getInteger("Duration");
        this.expansion = nbtRoot.getInteger("Expansion");
        if (nbtRoot.hasUniqueId("Thrower")) {
            this.thrower = nbtRoot.getUniqueId("Thrower");
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.getBlock() == newState.getBlock();
    }

    public int incRunTicks() {
        return ++this.runTicks;
    }
}

