/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.msrandom.witchery.block.BlockMirror;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityMirrorFace;
import net.msrandom.witchery.entity.passive.EntityFairest;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.data.WitcheryAlternateForms;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemQuartzGrenade;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.transformation.AlternateForm;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntityMirror
extends WitcheryTileEntity {
    private final Set<String> playersSeen = new HashSet<String>();
    public int men;
    long cooldown;
    long lastFairestSpawn;
    public BlockPos dimCoords;
    public int dim;
    public boolean isConnected;
    public boolean demonKilled;
    private UUID favorite;
    private UUID fairest;

    @Override
    public void update() {
        super.update();
        if (this.ticks % (long)(this.world.isRemote ? 10 : 40) == 1L) {
            EnumFacing side = BlockMirror.getDirection(this.world.getBlockState(this.getPos()));
            int xMin = -1;
            int xMax = 1;
            int zMin = -1;
            int zMax = 1;
            int scale = 4;
            switch (side) {
                case NORTH: {
                    zMin = -scale;
                    zMax = 0;
                    break;
                }
                case SOUTH: {
                    zMin = 0;
                    zMax = scale;
                    break;
                }
                case WEST: {
                    xMin = -scale;
                    xMax = 0;
                    break;
                }
                case EAST: {
                    xMin = 0;
                    xMax = scale;
                }
            }
            List entities = this.world.getEntitiesWithinAABB(EntityLivingBase.class, new AxisAlignedBB(this.pos.add(xMin, 0, zMin), this.pos.add(xMax + 1, 1, zMax + 1)));
            this.men = entities.size();
            if (!this.world.isRemote) {
                for (EntityLivingBase entity : entities) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    this.playersSeen.add(entity.getName());
                }
            }
        }
    }

    public void addCooldown(int i) {
        this.cooldown = this.ticks + (long)i;
    }

    public boolean onCooldown() {
        return this.ticks < this.cooldown;
    }

    public boolean isTargettedBy(ItemStack stack) {
        NBTTagCompound nbtRoot;
        if (!stack.isEmpty() && stack.getItem() == Item.getItemFromBlock((Block)WitcheryBlocks.MIRROR) && stack.getTagCompound() != null && (nbtRoot = stack.getTagCompound()).hasKey("DimCoords") && nbtRoot.hasKey("Dimension") && this.world.provider.getDimension() == nbtRoot.getInteger("Dimension")) {
            BlockPos coords = null;
            if (nbtRoot.hasKey("posX") && nbtRoot.hasKey("posY") && nbtRoot.hasKey("posZ")) {
                coords = new BlockPos(nbtRoot.getInteger("posX"), nbtRoot.getInteger("posY"), nbtRoot.getInteger("posZ"));
            }
            if (coords != null) {
                return coords.equals((Object)this.getPos());
            }
        }
        return false;
    }

    public void depolyDemon(EntityPlayer player, EnumHand hand) {
        if (!this.demonKilled && !WitcheryDimensions.MIRROR.isCurrentDimension(this.world)) {
            if (player.getHeldItem(hand).getItem() == WitcheryGeneralItems.BOUND_TAGLOCK_KIT) {
                PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                AlternateForm currentTransform = playerEx.getCurrentForm();
                if (currentTransform == null || currentTransform == WitcheryAlternateForms.PLAYER) {
                    UUID id = ItemTaglockKit.getBoundCreatureID(player.getHeldItem(hand), 0);
                    if (player.getUniqueID().equals(id)) {
                        if (currentTransform == WitcheryAlternateForms.PLAYER) {
                            player.playSound(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY, player.posZ, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)player);
                            playerEx.setCurrentForm(null);
                        } else {
                            player.playSound(SoundEvents.BLOCK_NOTE_SNARE, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY, player.posZ, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)player);
                        }
                    } else {
                        IPowerSource power = PowerSources.findClosestPowerSource(this);
                        if (power != null && power.consumePower(4000.0f)) {
                            GameProfile profile;
                            player.playSound(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY, player.posZ, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)player);
                            EntityPlayer otherPlayer = WitcheryUtils.getPlayer(this.world, id);
                            Object name2 = otherPlayer == null ? ((profile = this.world.getMinecraftServer().getPlayerProfileCache().getProfileByUUID(id)) == null ? null : profile.getName()) : otherPlayer.getName();
                            if (name2 != null) {
                                playerEx.setOtherPlayerSkin((String)name2);
                            }
                            playerEx.setCurrentForm(WitcheryAlternateForms.PLAYER);
                        } else {
                            player.playSound(SoundEvents.BLOCK_NOTE_SNARE, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY, player.posZ, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)player);
                        }
                    }
                }
            } else if (player.getHeldItem(hand).getItem() == WitcheryIngredientItems.QUARTZ_SPHERE) {
                IPowerSource power2 = PowerSources.findClosestPowerSource(this);
                if (power2 != null && power2.consumePower(2000.0f)) {
                    player.playSound(SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY, player.posZ, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)player);
                    ItemStack itemstack = player.getHeldItem(hand);
                    if (itemstack.getCount() > 1) {
                        ItemStack newStack = new ItemStack((Item)WitcheryGeneralItems.DUP_GRENADE);
                        ItemQuartzGrenade.setOwnerName(newStack, player.getUniqueID());
                        itemstack.shrink(1);
                        if (!player.inventory.addItemStackToInventory(newStack)) {
                            this.world.spawnEntity((Entity)new EntityItem(this.world, player.posX + 0.5, player.posY + 1.5, player.posZ + 0.5, newStack));
                        } else if (player instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                        }
                    } else {
                        ItemStack newStack = new ItemStack((Item)WitcheryGeneralItems.DUP_GRENADE);
                        ItemQuartzGrenade.setOwnerName(newStack, player.getUniqueID());
                        player.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, newStack);
                        if (player instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                        }
                    }
                } else {
                    player.playSound(SoundEvents.BLOCK_NOTE_SNARE, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY, player.posZ, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)player);
                }
            } else {
                List faces = this.world.getEntitiesWithinAABB(EntityMirrorFace.class, WitcheryBlocks.MIRROR.getBoundingBox(this.world.getBlockState(this.getPos()), (IBlockAccess)this.world, this.getPos()));
                if (faces.size() == 0) {
                    this.showMirrorHead(this.world, this.getPos());
                    this.world.playSound(null, this.pos, WitcherySounds.ENTITY_REFLECTION_AMBIENT, SoundCategory.PLAYERS, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)this.pos.getX() + 0.5, (double)this.pos.getY(), (double)this.pos.getZ() + 0.5, 0.5f, 0.5f, 0x7777FF), this.world, this.pos);
                    double RANGE = 64.0;
                    List players = this.world.playerEntities;
                    for (EntityPlayer otherPlayer : players) {
                        if (!(player.getDistanceSq(this.getPos()) <= RANGE * RANGE)) continue;
                        otherPlayer.sendMessage((ITextComponent)new TextComponentTranslation(WitcheryBlocks.MIRROR.getTranslationKey() + ".fairest", new Object[]{player.getName()}));
                    }
                    boolean fairestFound = false;
                    int nx = this.getPos().getX();
                    int ny = this.getPos().getY();
                    int nz = this.getPos().getZ();
                    if (this.fairest != null) {
                        double R = 100.0;
                        double RY = 32.0;
                        AxisAlignedBB bounds = new AxisAlignedBB((double)nx - R, (double)ny - RY, (double)nz - R, (double)nx + R, (double)ny + RY, (double)nz + R);
                        List followers = this.world.getEntitiesWithinAABB(EntityFairest.class, bounds);
                        for (EntityFairest follower : followers) {
                            if (!follower.getPersistentID().equals(this.fairest) || !follower.isEntityAlive()) continue;
                            this.sayNotFairest(player, follower);
                            fairestFound = true;
                            break;
                        }
                    }
                    if (!fairestFound) {
                        boolean isFairestAllowed = this.world.getTotalWorldTime() > this.lastFairestSpawn + 2400L;
                        this.fairest = null;
                        if (this.favorite == null || this.isFavorite(player)) {
                            EntityFairest fairestEntity;
                            this.favorite = player.getUniqueID();
                            double CHANCE_OF_NEW_FAIREST = WitcheryConfigOptions.fairestSpawnChance / 100.0;
                            if (isFairestAllowed && this.world.rand.nextDouble() < CHANCE_OF_NEW_FAIREST && (fairestEntity = WitcheryEntities.FAIREST.create(this.world)) != null) {
                                int type = this.world.rand.nextInt(3);
                                fairestEntity.enablePersistence();
                                fairestEntity.setType(type);
                                BlockPos coord = null;
                                int minRange = 50;
                                block2: for (int i = 0; i < 25 && coord == null; ++i) {
                                    int x = nx + (this.world.rand.nextBoolean() ? 1 : -1) * (minRange + this.world.rand.nextInt(minRange));
                                    int z = nz + (this.world.rand.nextBoolean() ? 1 : -1) * (minRange + this.world.rand.nextInt(minRange));
                                    int yMin = Math.max(ny - 20, 2);
                                    for (int y = Math.min(ny + 20, 250); y >= yMin; --y) {
                                        BlockPos p = new BlockPos(x, y, z);
                                        if (!this.world.getBlockState(p).isNormalCube() || !this.world.getBlockState(p.up()).getMaterial().isReplaceable() || !this.world.isAirBlock(p.up(2))) continue;
                                        coord = p;
                                        continue block2;
                                    }
                                }
                                if (coord != null) {
                                    fairestEntity.setPositionAndRotation((double)coord.getX() + 0.5, (double)coord.getY() + 1.01, (double)coord.getZ() + 0.5, 0.0f, 0.0f);
                                    this.world.spawnEntity((Entity)fairestEntity);
                                    this.fairest = fairestEntity.getPersistentID();
                                    fairestFound = true;
                                    this.lastFairestSpawn = this.world.getTotalWorldTime();
                                    this.sayNotFairest(player, fairestEntity);
                                }
                            }
                            if (!fairestFound) {
                                player.sendMessage(new TextComponentTranslation(WitcheryBlocks.MIRROR.getTranslationKey() + ".you", new Object[0]).setStyle(new Style().setColor(TextFormatting.AQUA)));
                            }
                        } else {
                            player.sendMessage(new TextComponentTranslation(WitcheryBlocks.MIRROR.getTranslationKey() + ".fairer", new Object[0]).setStyle(new Style().setColor(TextFormatting.AQUA)));
                            EntityPlayer otherPlayer2 = WitcheryUtils.getPlayer(this.world, this.favorite);
                            if (otherPlayer2 != null) {
                                this.sayBearing(player, (EntityLivingBase)otherPlayer2);
                            }
                        }
                    }
                    if (this.playersSeen.size() > 1) {
                        ArrayList<String> seen = new ArrayList<String>(this.playersSeen);
                        Collections.sort(seen);
                        StringBuilder sb = new StringBuilder();
                        for (String s : seen) {
                            if (s.equals(player.getName())) continue;
                            if (sb.length() > 0) {
                                sb.append(", ");
                            }
                            sb.append(s);
                        }
                        if (sb.length() > 0) {
                            player.sendMessage(new TextComponentTranslation(WitcheryBlocks.MIRROR.getTranslationKey() + ".players_before_current", new Object[]{sb.toString()}).setStyle(new Style().setColor(TextFormatting.AQUA)));
                        } else {
                            player.sendMessage(new TextComponentTranslation(WitcheryBlocks.MIRROR.getTranslationKey() + ".no_players_before", new Object[0]).setStyle(new Style().setColor(TextFormatting.AQUA)));
                        }
                    } else {
                        player.sendMessage(new TextComponentTranslation(WitcheryBlocks.MIRROR.getTranslationKey() + ".no_players_before", new Object[0]).setStyle(new Style().setColor(TextFormatting.AQUA)));
                    }
                    if (this.isFavorite(player)) {
                        this.playersSeen.clear();
                    }
                }
            }
        }
    }

    public void sayNotFairest(EntityPlayer player, EntityFairest follower) {
        player.sendMessage(new TextComponentTranslation(WitcheryBlocks.MIRROR.getTranslationKey() + ".fairer", new Object[0]).setStyle(new Style().setColor(TextFormatting.AQUA)));
        this.sayBearing(player, (EntityLivingBase)follower);
    }

    public void sayBearing(EntityPlayer player, EntityLivingBase otherEntity) {
        int bearingIndex;
        double bearingRadians = Math.atan2(0.5 + (double)this.getPos().getX() - otherEntity.posZ, 0.5 + (double)this.getPos().getX() - otherEntity.posX);
        double bearing = (Math.toDegrees(bearingRadians) + 180.0 + 90.0) % 360.0;
        if (bearing < 0.0) {
            bearing += 360.0;
        }
        if ((bearingIndex = (int)bearing / 45) > 7 || bearingIndex < 0) {
            bearingIndex = 0;
        }
        player.sendMessage(new TextComponentTranslation(WitcheryBlocks.MIRROR.getTranslationKey() + ".bearing" + bearingIndex, new Object[0]).setStyle(new Style().setColor(TextFormatting.AQUA)));
    }

    private void showMirrorHead(World world, BlockPos pos) {
        EnumFacing side = BlockMirror.getDirection(world.getBlockState(pos));
        float dx = 0.0f;
        float dz = 0.0f;
        float scale = 0.4f;
        switch (side) {
            case NORTH: {
                dz = scale;
                break;
            }
            case SOUTH: {
                dz = -scale;
                break;
            }
            case WEST: {
                dx = scale;
                break;
            }
            case EAST: {
                dx = -scale;
            }
        }
        EntityMirrorFace face = new EntityMirrorFace(world);
        face.setPosition((double)pos.getX() + 0.5 + (double)dx, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5 + (double)dz);
        world.spawnEntity((Entity)face);
    }

    public boolean isDimLinked() {
        return this.dimCoords != null;
    }

    public BlockPos getDimCoords() {
        if (this.dimCoords == null && !WitcheryDimensions.MIRROR.isCurrentDimension(this.world)) {
            WorldServer mirrorWorld = this.world.getMinecraftServer().getWorld(WitcheryDimensions.MIRROR.getType().getId());
            EnumFacing[] map = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.EAST};
            int cellX = 0;
            int cellZ = 0;
            int sign = 1;
            for (int i = 0; i < 256; ++i) {
                for (int spin = 0; spin <= i; ++spin) {
                    for (EnumFacing facing : map) {
                        if (i > 0) {
                            cellX += facing.getXOffset() * sign;
                            cellZ += facing.getZOffset() * sign;
                        }
                        int Y_LEVELS = WitcheryConfigOptions.shrinkMirrorWorld ? 8 : 15;
                        for (int cellY = 0; cellY < Y_LEVELS; ++cellY) {
                            int dimX = (cellX << 4) + 4;
                            int dimY = (cellY << 4) + 8;
                            int dimZ = (cellZ << 4) + 8;
                            BlockPos pos = new BlockPos(dimX, dimY, dimZ);
                            if (!mirrorWorld.isAirBlock(pos) || !mirrorWorld.isAirBlock(pos.down())) continue;
                            boolean stop = false;
                            for (int y = dimY - 1; y <= dimY + 6 && !stop; ++y) {
                                block5: for (int x = dimX; x <= dimX + 8 && !stop; ++x) {
                                    for (int z = dimZ - 4; z <= dimZ + 4; ++z) {
                                        if (mirrorWorld.isAirBlock(new BlockPos(x, y, z))) continue;
                                        stop = true;
                                        continue block5;
                                    }
                                }
                            }
                            if (stop) continue;
                            IBlockState meta = WitcheryBlocks.UNBREAKABLE_MIRROR.getDefaultState().withProperty((IProperty)BlockHorizontal.FACING, (Comparable)EnumFacing.EAST);
                            mirrorWorld.setBlockState(pos, meta.withProperty((IProperty)BlockMirror.TOP, (Comparable)Boolean.valueOf(true)), 3);
                            TileEntityMirror tile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)mirrorWorld, pos);
                            if (tile != null) {
                                tile.dimCoords = this.getPos();
                                tile.dim = this.world.provider.getDimension();
                            }
                            if (mirrorWorld.getBlockState(pos).getBlock() == meta.getBlock()) {
                                mirrorWorld.setBlockState(pos.down(), meta.withProperty((IProperty)BlockMirror.TOP, (Comparable)Boolean.valueOf(false)), 3);
                            }
                            this.dimCoords = new BlockPos(dimX, dimY, dimZ);
                            return this.dimCoords;
                        }
                    }
                }
                sign *= -1;
            }
        }
        return this.dimCoords;
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.getPos(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        NBTTagCompound nbtTag = packet2.getNbtCompound();
        this.readFromNBT(nbtTag);
        this.world.markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        nbtRoot.setLong("LastFairestSpawnTime", this.lastFairestSpawn);
        this.writeItemDataToNBT(nbtRoot);
        return nbtRoot;
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.lastFairestSpawn = nbtRoot.getLong("LastFairestSpawnTime");
        this.readItemDataFromNBT(nbtRoot);
    }

    public void writeItemDataToNBT(NBTTagCompound nbtRoot) {
        if (this.dimCoords != null) {
            NBTTagCompound nbtDim = new NBTTagCompound();
            nbtDim.setInteger("posX", this.dimCoords.getX());
            nbtDim.setInteger("posY", this.dimCoords.getY());
            nbtDim.setInteger("posZ", this.dimCoords.getZ());
            nbtDim.setInteger("Dimension", this.dim);
            nbtRoot.setTag("DimCoords", (NBTBase)nbtDim);
        }
        nbtRoot.setBoolean("DemonSlain", this.demonKilled);
        if (this.favorite != null) {
            nbtRoot.setUniqueId("Favorite", this.favorite);
        }
        if (this.fairest != null) {
            nbtRoot.setUniqueId("Fairest", this.fairest);
        }
        NBTTagList players = new NBTTagList();
        for (String player : this.playersSeen) {
            players.appendTag((NBTBase)new NBTTagString(player));
        }
        nbtRoot.setTag("PlayersSeen", (NBTBase)players);
    }

    public void readItemDataFromNBT(NBTTagCompound nbtRoot) {
        if (nbtRoot.hasKey("DimCoords")) {
            NBTTagCompound nbtDim = nbtRoot.getCompoundTag("DimCoords");
            BlockPos coord = null;
            if (nbtDim.hasKey("posX") && nbtDim.hasKey("posY") && nbtDim.hasKey("posZ")) {
                coord = new BlockPos(nbtDim.getInteger("posX"), nbtDim.getInteger("posY"), nbtDim.getInteger("posZ"));
            }
            this.dimCoords = coord;
            this.dim = nbtDim.getInteger("Dimension");
        }
        this.demonKilled = nbtRoot.getBoolean("DemonSlain");
        if (nbtRoot.hasUniqueId("Favorite")) {
            this.favorite = nbtRoot.getUniqueId("Favorite");
        }
        if (nbtRoot.hasUniqueId("Fairest")) {
            this.fairest = nbtRoot.getUniqueId("Fairest");
        }
        this.playersSeen.clear();
        if (nbtRoot.hasKey("PlayersSeen")) {
            NBTTagList players = nbtRoot.getTagList("PlayersSeen", 8);
            for (int i = 0; i < players.tagCount(); ++i) {
                this.playersSeen.add(players.getStringTagAt(i));
            }
        }
    }

    public boolean isFavorite(EntityPlayer player) {
        return this.favorite != null && player != null && this.favorite.equals(player.getGameProfile());
    }
}

