/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockLeechChest;
import net.msrandom.witchery.block.entity.TileEntityBloodTrap;

public class TileEntityLeechChest
extends TileEntityBloodTrap
implements IInventory,
ITickable {
    public boolean adjacentChestChecked;
    public TileEntity adjacentChestZNeg;
    public TileEntity adjacentChestXPos;
    public TileEntity adjacentChestXNeg;
    public TileEntity adjacentChestZPos;
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    private NonNullList<ItemStack> chestContents = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private int ticksSinceSync;
    private String customName;

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.getPos(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.readFromNBT(packet2.getNbtCompound());
        this.world.markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
    }

    public int getSizeInventory() {
        return 27;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.chestContents) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getStackInSlot(int par1) {
        return (ItemStack)this.chestContents.get(par1);
    }

    public ItemStack decrStackSize(int par1, int par2) {
        if (((ItemStack)this.chestContents.get(par1)).isEmpty()) {
            return null;
        }
        if (((ItemStack)this.chestContents.get(par1)).getCount() <= par2) {
            ItemStack itemstack = (ItemStack)this.chestContents.get(par1);
            this.chestContents.set(par1, (Object)ItemStack.EMPTY);
            this.markDirty();
            return itemstack;
        }
        ItemStack itemstack = ((ItemStack)this.chestContents.get(par1)).splitStack(par2);
        this.markDirty();
        return itemstack;
    }

    public ItemStack removeStackFromSlot(int par1) {
        if (!((ItemStack)this.chestContents.get(par1)).isEmpty()) {
            ItemStack itemstack = (ItemStack)this.chestContents.get(par1);
            this.chestContents.set(par1, (Object)ItemStack.EMPTY);
            return itemstack;
        }
        return null;
    }

    public void setInventorySlotContents(int par1, ItemStack par2ItemStack) {
        this.chestContents.set(par1, (Object)par2ItemStack);
        if (par2ItemStack.getCount() > this.getInventoryStackLimit()) {
            par2ItemStack.setCount(this.getInventoryStackLimit());
        }
        this.markDirty();
    }

    public String getName() {
        return this.hasCustomName() ? this.customName : "container.chest";
    }

    public boolean hasCustomName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public ITextComponent getDisplayName() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public void setChestGuiName(String par1Str) {
        this.customName = par1Str;
    }

    @Override
    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        NBTTagList nbtItemsList = par1NBTTagCompound.getTagList("Items", 10);
        this.chestContents = NonNullList.withSize((int)this.getSizeInventory(), (Object)ItemStack.EMPTY);
        if (par1NBTTagCompound.hasKey("CustomName")) {
            this.customName = par1NBTTagCompound.getString("CustomName");
        }
        for (int i = 0; i < nbtItemsList.tagCount(); ++i) {
            NBTTagCompound nbtItem = nbtItemsList.getCompoundTagAt(i);
            int j = nbtItem.getByte("Slot") & 0xFF;
            if (j >= this.chestContents.size()) continue;
            this.chestContents.set(j, (Object)new ItemStack(nbtItem));
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbtTag) {
        super.writeToNBT(nbtTag);
        NBTTagList nbtItemsList = new NBTTagList();
        for (int i = 0; i < this.chestContents.size(); ++i) {
            if (((ItemStack)this.chestContents.get(i)).isEmpty()) continue;
            NBTTagCompound nbtItem = new NBTTagCompound();
            nbtItem.setByte("Slot", (byte)i);
            ((ItemStack)this.chestContents.get(i)).writeToNBT(nbtItem);
            nbtItemsList.appendTag((NBTBase)nbtItem);
        }
        nbtTag.setTag("Items", (NBTBase)nbtItemsList);
        if (this.hasCustomName()) {
            nbtTag.setString("CustomName", this.customName);
        }
        return nbtTag;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUsableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.world.getTileEntity(this.getPos()) == this && par1EntityPlayer.getDistanceSq(this.getPos()) <= 64.0;
    }

    public void updateContainingBlockInfo() {
        super.updateContainingBlockInfo();
        this.adjacentChestChecked = false;
    }

    public void update() {
        int i = this.pos.getX();
        int j = this.pos.getY();
        int k = this.pos.getZ();
        ++this.ticksSinceSync;
        if (!this.world.isRemote && this.numPlayersUsing != 0 && (this.ticksSinceSync + i + j + k) % 200 == 0) {
            this.numPlayersUsing = 0;
            float f = 5.0f;
            for (EntityPlayer entityplayer : this.world.getEntitiesWithinAABB(EntityPlayer.class, new AxisAlignedBB((double)((float)i - f), (double)((float)j - f), (double)((float)k - 5.0f), (double)((float)(i + 1) + f), (double)((float)(j + 1) + f), (double)((float)(k + 1) + f)))) {
                IInventory iinventory;
                if (!(entityplayer.openContainer instanceof ContainerChest) || (iinventory = ((ContainerChest)entityplayer.openContainer).getLowerChestInventory()) != this && (!(iinventory instanceof InventoryLargeChest) || !((InventoryLargeChest)iinventory).isPartOfLargeChest((IInventory)this))) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        float f1 = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f && this.adjacentChestZNeg == null && this.adjacentChestXNeg == null) {
            double d1 = (double)i + 0.5;
            double d2 = (double)k + 0.5;
            if (this.adjacentChestZPos != null) {
                d2 += 0.5;
            }
            if (this.adjacentChestXPos != null) {
                d1 += 0.5;
            }
            this.world.playSound(null, d1, (double)j + 0.5, d2, SoundEvents.BLOCK_CHEST_OPEN, SoundCategory.BLOCKS, 0.5f, this.world.rand.nextFloat() * f1 + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f3;
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += f1) : (this.lidAngle -= f1);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f3 = 0.5f) && f2 >= f3 && this.adjacentChestZNeg == null && this.adjacentChestXNeg == null) {
                double d3 = (double)i + 0.5;
                double d0 = (double)k + 0.5;
                if (this.adjacentChestZPos != null) {
                    d0 += 0.5;
                }
                if (this.adjacentChestXPos != null) {
                    d3 += 0.5;
                }
                this.world.playSound(null, d3, (double)j + 0.5, d0, SoundEvents.BLOCK_CHEST_CLOSE, SoundCategory.BLOCKS, 0.5f, this.world.rand.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean receiveClientEvent(int par1, int par2) {
        if (par1 == 1) {
            this.numPlayersUsing = par2;
            return true;
        }
        return super.receiveClientEvent(par1, par2);
    }

    public void openInventory(EntityPlayer player) {
        if (!player.isSpectator()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.world.addBlockEvent(this.pos, this.getBlockType(), 1, this.numPlayersUsing);
            this.world.notifyNeighborsOfStateChange(this.pos, this.getBlockType(), false);
            this.world.notifyNeighborsOfStateChange(this.pos.down(), this.getBlockType(), false);
        }
    }

    public void closeInventory(EntityPlayer player) {
        if (!player.isSpectator() && this.getBlockType() instanceof BlockLeechChest) {
            --this.numPlayersUsing;
            this.world.addBlockEvent(this.pos, this.getBlockType(), 1, this.numPlayersUsing);
            this.world.notifyNeighborsOfStateChange(this.pos, this.getBlockType(), false);
            this.world.notifyNeighborsOfStateChange(this.pos.down(), this.getBlockType(), false);
        }
    }

    public boolean isItemValidForSlot(int par1, ItemStack par2ItemStack) {
        return true;
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
        this.chestContents.clear();
    }

    public void invalidate() {
        super.invalidate();
        this.updateContainingBlockInfo();
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.getBlock() == newState.getBlock();
    }
}

