/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.WaterContainer;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.recipe.KettleRecipe;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntityKettle
extends WitcheryTileEntity
implements ISidedInventory,
WaterContainer {
    private static final int RESULT_SLOT = 6;
    private static final int BOTTLE_SLOT = 7;
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private final FluidTank tank = new FluidTank(1000);
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
    private boolean isRuined;
    public boolean isPowered;
    private int lastExtractionQuantity;
    private boolean consumeBottles;

    private static IPowerSource findNewPowerSource(World world, BlockPos pos) {
        List<PowerSources.RelativePowerSource> sources = PowerSources.instance().get(world, pos);
        return sources != null && sources.size() > 0 ? sources.get(0).source() : null;
    }

    @Override
    public void update() {
        super.update();
        if (!(this.world.isRemote || this.isRuined || this.ticks % 20L != 0L || !this.isFilled() || !this.someFilled() && ((ItemStack)this.furnaceItemStacks.get(6)).isEmpty())) {
            boolean sendPacket = false;
            if (this.world.getBlockState(this.getPos().down()).getMaterial() != Material.FIRE) {
                this.isRuined = true;
                this.furnaceItemStacks.set(6, (Object)ItemStack.EMPTY);
            } else if (((ItemStack)this.furnaceItemStacks.get(6)).isEmpty()) {
                Optional<KettleRecipe> recipeOptional = WitcheryUtils.getRecipeManager(this.world).getRecipe(WitcheryRecipeTypes.KETTLE, this, this.world);
                if (this.allFilled()) {
                    Optional<ItemStack> result2 = recipeOptional.map(r -> r.craft(this));
                    if (!result2.isPresent() || result2.get().isEmpty()) {
                        this.isRuined = true;
                        this.furnaceItemStacks.set(6, (Object)ItemStack.EMPTY);
                    } else {
                        KettleRecipe recipe = recipeOptional.get();
                        boolean wasPowered = this.isPowered;
                        float powerNeeded = recipe.getPowerRequired();
                        if (powerNeeded == 0.0f) {
                            this.isPowered = true;
                        } else {
                            IPowerSource powerSource = TileEntityKettle.findNewPowerSource(this.world, this.getPos());
                            boolean bl = this.isPowered = powerSource != null && powerSource.consumePower(powerNeeded);
                        }
                        if (this.isPowered) {
                            this.furnaceItemStacks.set(6, (Object)result2.get());
                            for (int i = 0; i < this.furnaceItemStacks.size() - 2; ++i) {
                                this.furnaceItemStacks.set(i, (Object)ItemStack.EMPTY);
                            }
                        }
                        sendPacket = this.isPowered || wasPowered;
                    }
                } else {
                    if (!recipeOptional.isPresent()) {
                        this.isRuined = true;
                        this.furnaceItemStacks.set(6, (Object)ItemStack.EMPTY);
                    }
                    if (!this.isRuined) {
                        IPowerSource powerSource;
                        KettleRecipe recipe = recipeOptional.get();
                        boolean wasPowered = this.isPowered;
                        float powerNeeded = recipe.getPowerRequired();
                        this.isPowered = powerNeeded == 0.0f ? true : (powerSource = TileEntityKettle.findNewPowerSource(this.world, this.getPos())) != null && powerSource.getCurrentPower() >= powerNeeded;
                        boolean bl = sendPacket = wasPowered != this.isPowered;
                    }
                }
            }
            if (this.isRuined || sendPacket) {
                BlockUtil.notifyBlockUpdate(this.world, this.getPos());
            }
        }
    }

    public void reset(boolean flushWater) {
        if (!this.world.isRemote) {
            if (flushWater) {
                this.tank.drain(this.tank.getFluidAmount(), true);
            }
            this.isRuined = false;
            this.isPowered = false;
            for (int i = 0; i < this.furnaceItemStacks.size() - 1; ++i) {
                this.furnaceItemStacks.set(i, (Object)ItemStack.EMPTY);
            }
            this.markDirty();
        }
    }

    public boolean allFilled() {
        for (int i = 0; i < this.furnaceItemStacks.size() - 2; ++i) {
            if (!((ItemStack)this.furnaceItemStacks.get(i)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean someFilled() {
        for (int i = 0; i < this.furnaceItemStacks.size() - 2; ++i) {
            if (((ItemStack)this.furnaceItemStacks.get(i)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public int getSizeInventory() {
        return this.furnaceItemStacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.furnaceItemStacks) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (slot == 6) {
            return true;
        }
        if (slot == 7) {
            return itemstack.getItem() == Items.GLASS_BOTTLE && stackInSlot.getCount() + itemstack.getCount() <= this.getInventoryStackLimit();
        }
        return this.getStackInSlot(6).isEmpty() && stackInSlot.getCount() + itemstack.getCount() <= this.getInventoryStackLimit();
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
        this.furnaceItemStacks.clear();
    }

    public int[] getSlotsForFace(EnumFacing var1) {
        return SLOTS;
    }

    public boolean canInsertItem(int slot, ItemStack stack, EnumFacing side) {
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (slot == 6) {
            return false;
        }
        if (slot == 7) {
            return stack.getItem() == Items.GLASS_BOTTLE && stackInSlot.getCount() + stack.getCount() <= this.getInventoryStackLimit();
        }
        return stack.getItem() != Items.GLASS_BOTTLE && this.getStackInSlot(6).isEmpty() && this.isFilled();
    }

    public boolean canExtractItem(int slot, ItemStack stack, EnumFacing side) {
        boolean canExtract;
        ItemStack bottles = this.getStackInSlot(7);
        boolean bl = canExtract = slot == 6 && this.isFilled() && this.isReady() && !bottles.isEmpty() && bottles.getCount() >= stack.getCount();
        if (canExtract) {
            Optional<KettleRecipe> recipe = WitcheryUtils.getRecipeManager(this.world).getRecipe(WitcheryRecipeTypes.KETTLE, this, this.world);
            if (recipe.isPresent() && recipe.get().getFamiliarPower() == null) {
                return false;
            }
            this.lastExtractionQuantity = stack.getCount();
        }
        return canExtract;
    }

    @SideOnly(value=Side.CLIENT)
    public int getLiquidColor() {
        return WitcheryUtils.getColor(this.furnaceItemStacks);
    }

    public ItemStack getStackInSlot(int par1) {
        return (ItemStack)this.furnaceItemStacks.get(par1);
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        if (slot == 6 && this.consumeBottles) {
            ItemStack resultStack = this.getStackInSlot(6);
            ItemStack bottleStack = this.getStackInSlot(7);
            if (stack.isEmpty() && !resultStack.isEmpty() && !bottleStack.isEmpty()) {
                bottleStack.shrink(resultStack.getCount());
            } else if (!(stack.isEmpty() || resultStack.isEmpty() || bottleStack.isEmpty())) {
                int reduction = resultStack.getCount() - stack.getCount();
                if (reduction == 0) {
                    reduction = this.lastExtractionQuantity;
                }
                this.lastExtractionQuantity = 0;
                bottleStack.shrink(reduction);
            }
        }
        this.furnaceItemStacks.set(slot, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getInventoryStackLimit()) {
            stack.setCount(this.getInventoryStackLimit());
        } else if (stack.isEmpty() && slot == 6) {
            this.reset(true);
            return;
        }
        if (!this.world.isRemote) {
            this.markDirty();
        }
    }

    @Deprecated
    public void setConsumeBottle(boolean consume) {
        this.consumeBottles = consume;
    }

    public ItemStack decrStackSize(int slot, int quantity) {
        if (((ItemStack)this.furnaceItemStacks.get(slot)).isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack bottles = this.getStackInSlot(7);
        if (this.consumeBottles && !bottles.isEmpty()) {
            bottles.shrink(quantity);
        }
        if (((ItemStack)this.furnaceItemStacks.get(slot)).getCount() <= quantity) {
            ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(slot);
            this.furnaceItemStacks.set(slot, (Object)ItemStack.EMPTY);
            if (slot == 6) {
                this.reset(true);
            } else if (!this.world.isRemote) {
                BlockUtil.notifyBlockUpdate(this.world, this.getPos());
            }
            return itemstack;
        }
        ItemStack itemstack = ((ItemStack)this.furnaceItemStacks.get(slot)).splitStack(quantity);
        if (((ItemStack)this.furnaceItemStacks.get(slot)).isEmpty()) {
            if (slot == 6) {
                this.reset(true);
            } else if (!this.world.isRemote) {
                BlockUtil.notifyBlockUpdate(this.world, this.getPos());
            }
        } else if (!this.world.isRemote) {
            BlockUtil.notifyBlockUpdate(this.world, this.getPos());
        }
        return itemstack;
    }

    public ItemStack removeStackFromSlot(int par1) {
        BlockUtil.notifyBlockUpdate(this.world, this.getPos());
        return ItemStackHelper.getAndRemove(this.furnaceItemStacks, (int)par1);
    }

    public String getName() {
        return this.getBlockType().getLocalizedName();
    }

    public boolean hasCustomName() {
        return true;
    }

    public ITextComponent getDisplayName() {
        return new TextComponentString(this.getName());
    }

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        if (this.tank.getFluidAmount() > 0) {
            this.tank.drain(this.tank.getFluidAmount(), true);
        }
        this.tank.readFromNBT(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.getTagList("Items", 10);
        this.furnaceItemStacks = NonNullList.withSize((int)this.getSizeInventory(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
            byte b0 = nbttagcompound1.getByte("Slot");
            if (b0 < 0 || b0 >= this.furnaceItemStacks.size()) continue;
            this.furnaceItemStacks.set((int)b0, (Object)new ItemStack(nbttagcompound1));
        }
        this.isRuined = par1NBTTagCompound.getBoolean("Ruined");
        this.isPowered = par1NBTTagCompound.getBoolean("Powered");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("Ruined", this.isRuined);
        par1NBTTagCompound.setBoolean("Powered", this.isPowered);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            if (((ItemStack)this.furnaceItemStacks.get(i)).isEmpty()) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            ((ItemStack)this.furnaceItemStacks.get(i)).writeToNBT(nbttagcompound1);
            nbttaglist.appendTag((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.setTag("Items", (NBTBase)nbttaglist);
        this.tank.writeToNBT(par1NBTTagCompound);
        return par1NBTTagCompound;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public boolean isUsableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.world.getTileEntity(this.getPos()) == this && par1EntityPlayer.getDistanceSq(this.getPos()) <= 64.0;
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.getPos(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.handleUpdateTag(packet2.getNbtCompound());
    }

    public boolean isFilled() {
        return this.tank.getFluidAmount() == this.tank.getCapacity();
    }

    public boolean isBrewing() {
        return this.isFilled() && this.someFilled() && !this.isRuined();
    }

    public boolean isReady() {
        return !this.isRuined() && !((ItemStack)this.furnaceItemStacks.get(6)).isEmpty();
    }

    public boolean isRuined() {
        return this.isRuined;
    }

    public void setRuined() {
        this.isRuined = true;
        BlockUtil.notifyBlockUpdate(this.world, this.getPos());
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(Fluid fluid) {
        return fluid != null && fluid == FluidRegistry.WATER;
    }

    public boolean canDrain(Fluid fluid) {
        return fluid != null && fluid == FluidRegistry.WATER;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int bottleCount() {
        ItemStack stack = this.getStackInSlot(7);
        return !stack.isEmpty() ? stack.getCount() : 0;
    }

    @Override
    public int getQuantity() {
        return 1000;
    }
}

