/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityGrassper
extends TileEntity
implements IInventory {
    private ItemStack item = ItemStack.EMPTY;

    public int getSizeInventory() {
        return 1;
    }

    public boolean isEmpty() {
        return this.item.isEmpty();
    }

    public ItemStack getStackInSlot(int slot) {
        return slot == 0 ? this.item : ItemStack.EMPTY;
    }

    public ItemStack decrStackSize(int slot, int size) {
        return slot == 0 ? this.item.splitStack(size) : ItemStack.EMPTY;
    }

    public ItemStack removeStackFromSlot(int slot) {
        if (slot == 0) {
            ItemStack stack = this.item;
            this.item = ItemStack.EMPTY;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        if (slot == 0) {
            if (stack.getCount() > this.getInventoryStackLimit()) {
                stack.setCount(this.getInventoryStackLimit());
            }
            this.item = stack;
        }
    }

    public String getName() {
        return this.getBlockType().getTranslationKey() + ".name";
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 1, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.readFromNBT(packet2.getNbtCompound());
        this.world.markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
    }

    public boolean hasCustomName() {
        return false;
    }

    @Nonnull
    public ITextComponent getDisplayName() {
        return new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.item = tag.hasKey("Item") ? new ItemStack(tag.getCompoundTag("Item")) : ItemStack.EMPTY;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        if (!this.item.isEmpty()) {
            tag.setTag("Item", (NBTBase)this.item.writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.world.getTileEntity(this.getPos()) == this && player.getDistanceSq(this.getPos()) <= 64.0;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return slot == 0 && this.item.isEmpty();
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
    }
}

