/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.entity.EntityGoblin;
import net.msrandom.witchery.entity.EntityIllusion;
import net.msrandom.witchery.entity.EntitySleepingBody;
import net.msrandom.witchery.entity.EntitySpirit;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.entity.passive.coven.EntityCovenWitch;
import net.msrandom.witchery.infusion.spirit.InfusedSpiritEffect;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.util.BlockUtil;

public class TileEntityFetish
extends WitcheryTileEntity {
    private static Set<Class<?>> groupables;
    final int TRIGGER_WHEN_PLAYER_NOT_IN_WHITELIST = 0;
    final int TRIGGER_WHEN_PLAYER_IN_BLACKLIST = 1;
    final int TRIGGER_WHEN_CREATURE_NOT_IN_WHITELIST = 2;
    final int TRIGGER_WHEN_NOT_ALL_CREATURES_FOUND = 3;
    final int TRIGGER_WHEN_SOME_CREATURES_NOT_FOUND = 4;
    final int TRIGGER_OFF = 5;
    boolean lastRaiseAlarm;
    long lastActivationTime;
    int alarmMode = 5;
    private int color = 0;
    private InfusedSpiritEffect effect;
    private final Set<UUID> knownPlayers = new LinkedHashSet<UUID>();
    private final Set<Class<? extends Entity>> knownCreatureTypes = new LinkedHashSet<Class<? extends Entity>>();
    private final Set<UUID> knownCreatures = new LinkedHashSet<UUID>();

    @Override
    public void update() {
        super.update();
        if (!this.world.isRemote && this.ticks % 20L == 0L && this.effect != null && this.effect.getRadius() > 0.0) {
            boolean someFound = false;
            int found = 0;
            int someLeft = 0;
            HashSet<String> foundTypes = new HashSet<String>();
            ArrayList<EntityLivingBase> foundEntities = new ArrayList<EntityLivingBase>();
            if (this.alarmMode != 5) {
                double RADIUS = this.effect.getRadius();
                AxisAlignedBB bb = new AxisAlignedBB(0.5 + (double)this.getPos().getX() - RADIUS, 0.5 + (double)this.getPos().getY() - RADIUS, 0.5 + (double)this.getPos().getZ() - RADIUS, 0.5 + (double)this.getPos().getX() + RADIUS, 0.5 + (double)this.getPos().getY() + RADIUS, 0.5 + (double)this.getPos().getZ() + RADIUS);
                List entities = this.alarmMode == 0 || this.alarmMode == 1 ? this.world.getEntitiesWithinAABB(EntityPlayer.class, bb) : this.world.getEntitiesWithinAABB(EntityLivingBase.class, bb);
                someLeft = entities.size();
                for (EntityLivingBase obj : entities) {
                    if (obj instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)obj;
                        if (this.knownPlayers.contains(player.getUniqueID())) {
                            someFound = true;
                            ++found;
                            --someLeft;
                            if (this.alarmMode != 1) {
                                continue;
                            }
                        } else if (this.alarmMode != 2 && this.alarmMode != 0) continue;
                        foundEntities.add((EntityLivingBase)player);
                        continue;
                    }
                    if (!(obj instanceof EntityLiving) || this.isIgnorableEntity((EntityLiving)obj)) continue;
                    EntityLiving creature = (EntityLiving)obj;
                    if (this.knownCreatureTypes.contains(creature.getClass())) {
                        someFound = true;
                        foundTypes.add(creature.getName());
                        --someLeft;
                        continue;
                    }
                    if (this.knownCreatures.contains(creature.getUniqueID())) {
                        someFound = true;
                        ++found;
                        --someLeft;
                        continue;
                    }
                    if (this.alarmMode != 2) continue;
                    foundEntities.add((EntityLivingBase)creature);
                }
            }
            boolean raiseAlarm = false;
            switch (this.alarmMode) {
                case 0: 
                case 2: {
                    raiseAlarm = someLeft > 0;
                    break;
                }
                case 1: {
                    raiseAlarm = someFound;
                    break;
                }
                case 3: {
                    raiseAlarm = found != this.knownCreatures.size() + this.knownPlayers.size() || this.knownCreatureTypes.size() != foundTypes.size();
                    break;
                }
                case 4: {
                    raiseAlarm = !someFound;
                }
            }
            int cooldown = this.effect.getCooldownTicks();
            long currentTime = this.world.getTotalWorldTime();
            if ((cooldown == -1 || currentTime > this.lastActivationTime + (long)cooldown) && this.effect.doUpdateEffect(this, raiseAlarm, foundEntities)) {
                this.lastActivationTime = currentTime;
            }
            if (this.lastRaiseAlarm != raiseAlarm) {
                this.lastRaiseAlarm = raiseAlarm;
                if (this.effect.isRedstoneSignaller()) {
                    BlockUtil.notifyNeighborsOfBlockChange(this.world, this.getPos(), this.getBlockType());
                }
            }
        }
    }

    private boolean isFamiliar(Entity entity) {
        if (Familiars.canBeFamiliar(entity)) {
            return Familiars.getFamiliarInstance(entity).isFamiliar();
        }
        return false;
    }

    private boolean isIgnorableEntity(EntityLiving entity) {
        return entity instanceof EntitySleepingBody || entity instanceof EntityIllusion || entity instanceof EntitySpirit || this.isFamiliar((Entity)entity);
    }

    public int getPowerLevel() {
        if (this.effect != null && this.effect.isRedstoneSignaller()) {
            return this.lastRaiseAlarm ? 15 : 0;
        }
        return 0;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int dyeColor) {
        this.color = dyeColor;
        if (this.world != null && !this.world.isRemote) {
            BlockUtil.notifyBlockUpdate(this.world, this.getPos());
            this.syncSpectralEntities();
        }
    }

    public InfusedSpiritEffect getEffect() {
        return this.effect;
    }

    public void setEffect(InfusedSpiritEffect effect) {
        this.effect = effect;
        if (this.world != null && !this.world.isRemote) {
            BlockUtil.notifyBlockUpdate(this.world, this.getPos());
        }
    }

    public void syncSpectralEntities() {
        TileEntityFetish tile;
        WorldServer overworld;
        if (this.world != null && !this.world.isRemote && WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(this.world) && (overworld = this.world.getMinecraftServer().getWorld(0)).getBlockState(this.getPos()).getBlock() == this.getBlockType() && (tile = WitcheryTileEntities.FETISH.getAt((IBlockAccess)overworld, this.getPos())) != null) {
            NBTTagCompound nbtOurData = new NBTTagCompound();
            this.writeSubDataToNBT(nbtOurData);
            tile.readSubDataFromNBT(nbtOurData);
        }
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.getPos(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.readFromNBT(packet2.getNbtCompound());
        this.world.markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.lastActivationTime = nbtRoot.getLong("LastActivation");
        this.readSubDataFromNBT(nbtRoot);
    }

    public void readSubDataFromNBT(NBTTagCompound tag) {
        int i;
        if (tag.hasKey("BlockColor")) {
            this.color = tag.getByte("BlockColor");
        }
        if (tag.hasKey("EffectType")) {
            this.effect = (InfusedSpiritEffect)InfusedSpiritEffect.REGISTRY.get(new ResourceLocation(tag.getString("EffectType")));
        }
        this.alarmMode = tag.hasKey("AlarmMode") ? tag.getInteger("AlarmMode") : 5;
        if (tag.hasKey("KnownPlayers")) {
            NBTTagList players = tag.getTagList("KnownPlayers", 10);
            this.knownPlayers.clear();
            for (i = 0; i < players.tagCount(); ++i) {
                this.knownPlayers.add(UUID.fromString(players.getStringTagAt(i)));
            }
        }
        if (tag.hasKey("KnownCreatureTypes")) {
            NBTTagList creatureTypes = tag.getTagList("KnownCreatureTypes", 10);
            this.knownCreatureTypes.clear();
            for (i = 0; i < creatureTypes.tagCount(); ++i) {
                this.knownCreatureTypes.add(EntityList.getClass((ResourceLocation)new ResourceLocation(creatureTypes.getStringTagAt(i))));
            }
        }
        if (tag.hasKey("KnownCreatures")) {
            NBTTagList creatures = tag.getTagList("KnownCreatures", 10);
            this.knownCreatures.clear();
            for (i = 0; i < creatures.tagCount(); ++i) {
                this.knownCreatures.add(UUID.fromString(creatures.getStringTagAt(i)));
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        nbtRoot.setLong("LastActivation", this.lastActivationTime);
        this.writeSubDataToNBT(nbtRoot);
        return nbtRoot;
    }

    public void writeSubDataToNBT(NBTTagCompound tag) {
        tag.setByte("BlockColor", (byte)this.color);
        if (this.effect != null) {
            tag.setString("EffectType", ((ResourceLocation)InfusedSpiritEffect.REGISTRY.getKey(this.effect)).toString());
        }
        tag.setInteger("AlarmMode", this.alarmMode);
        if (!this.knownPlayers.isEmpty()) {
            NBTTagList players = new NBTTagList();
            for (UUID uUID : this.knownPlayers) {
                players.appendTag((NBTBase)new NBTTagString(uUID.toString()));
            }
            tag.setTag("KnownPlayers", (NBTBase)players);
        }
        if (!this.knownCreatureTypes.isEmpty()) {
            NBTTagList creatureTypes = new NBTTagList();
            for (Class clazz : this.knownCreatureTypes) {
                creatureTypes.appendTag((NBTBase)new NBTTagString(EntityList.getKey((Class)clazz).toString()));
            }
            tag.setTag("KnownCreatureTypes", (NBTBase)creatureTypes);
        }
        if (!this.knownCreatures.isEmpty()) {
            NBTTagList creatures = new NBTTagList();
            for (UUID uUID : this.knownCreatures) {
                creatures.appendTag((NBTBase)new NBTTagString(uUID.toString()));
            }
            tag.setTag("KnownCreatures", (NBTBase)creatures);
        }
    }

    private boolean isGroupableCreature(Class<? extends Entity> creatureName) {
        if (groupables == null) {
            groupables = new HashSet();
            this.addGroupableType(EntityVillager.class);
            this.addGroupableType(EntityGoblin.class);
            this.addGroupableType(EntitySheep.class);
            this.addGroupableType(EntityCow.class);
            this.addGroupableType(EntityMooshroom.class);
            this.addGroupableType(EntityChicken.class);
            this.addGroupableType(EntityPig.class);
            this.addGroupableType(EntityHorse.class);
            this.addGroupableType(EntityBat.class);
            this.addGroupableType(EntitySquid.class);
            this.addGroupableType(EntityCovenWitch.class);
        }
        return groupables.contains(creatureName);
    }

    public void setBoundEntity(ItemStack stack, EntityPlayer player, boolean readonly) {
        if (!this.world.isRemote && !stack.isEmpty()) {
            Class<? extends Entity> boundEntityType = ItemTaglockKit.getBoundEntityType(stack, 0);
            UUID id = ItemTaglockKit.getBoundCreatureID(stack, 0);
            if (boundEntityType != null) {
                if (boundEntityType == EntityPlayer.class) {
                    if (!readonly) {
                        if (!player.isSneaking() && !this.knownPlayers.contains(id)) {
                            this.knownPlayers.add(id);
                        } else {
                            this.knownPlayers.remove(id);
                        }
                        if (!player.capabilities.isCreativeMode) {
                            stack.shrink(1);
                        }
                        this.syncSpectralEntities();
                    }
                } else if (!readonly) {
                    if (this.isGroupableCreature(boundEntityType)) {
                        if (!player.isSneaking() && !this.knownCreatureTypes.contains(boundEntityType)) {
                            this.knownCreatureTypes.add(boundEntityType);
                        } else {
                            this.knownCreatureTypes.remove(boundEntityType);
                        }
                    } else if (!player.isSneaking() && !this.knownCreatures.contains(id)) {
                        this.knownCreatures.add(id);
                    } else {
                        this.knownCreatures.remove(id);
                    }
                    if (!player.capabilities.isCreativeMode) {
                        stack.shrink(1);
                    }
                    this.syncSpectralEntities();
                }
            }
            this.showCurrentKnownEntities(player);
        }
    }

    public void clearBoundEntities(ItemStack stack, EntityPlayer player) {
        if (player != null && !player.world.isRemote && !stack.isEmpty()) {
            this.knownCreatureTypes.clear();
            this.knownCreatures.clear();
            this.knownPlayers.clear();
            if (!player.capabilities.isCreativeMode) {
                player.inventory.setInventorySlotContents(player.inventory.currentItem, new ItemStack(Items.BUCKET));
            }
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
            }
            this.syncSpectralEntities();
            this.showCurrentKnownEntities(player);
        }
    }

    public void cycleBoundMode(EntityPlayer player) {
        if (!this.world.isRemote) {
            if (++this.alarmMode > 5) {
                this.alarmMode = 0;
            }
            this.syncSpectralEntities();
            this.showCurrentKnownEntities(player);
        }
    }

    private void addGroupableType(Class<? extends EntityLiving> type) {
        groupables.add(type);
    }

    private void showCurrentKnownEntities(EntityPlayer player) {
        WorldServer serverWorld = (WorldServer)this.world;
        PlayerProfileCache playerCache = serverWorld.getMinecraftServer().getPlayerProfileCache();
        TextComponentString text2 = new TextComponentString("");
        int names = 0;
        for (UUID uUID : this.knownPlayers) {
            String name2;
            ITextComponent displayName;
            Entity otherPlayer = serverWorld.getEntityFromUuid(uUID);
            if (otherPlayer == null) {
                GameProfile profile = playerCache.getProfileByUUID(uUID);
                String name3 = profile == null ? null : profile.getName();
                displayName = null;
            } else {
                name2 = null;
                displayName = otherPlayer.getDisplayName();
            }
            if (displayName == null && name2 == null) continue;
            if (names > 0) {
                text2.appendText(", ");
            }
            if (displayName == null) {
                text2.appendText(name2);
            } else {
                text2.appendSibling(displayName);
            }
            ++names;
        }
        for (Class clazz : this.knownCreatureTypes) {
            EntityEntry entry2 = EntityRegistry.getEntry((Class)clazz);
            if (entry2 == null) continue;
            if (names > 0) {
                text2.appendText(", ");
            }
            text2.appendText("#");
            text2.appendSibling((ITextComponent)new TextComponentTranslation("entity." + entry2.getName() + ".name", new Object[0]));
            ++names;
        }
        for (UUID uUID : this.knownCreatures) {
            Entity entity = serverWorld.getEntityFromUuid(uUID);
            if (entity == null) continue;
            if (names > 0) {
                text2.appendText(", ");
            }
            text2.appendSibling(entity.getDisplayName());
            ++names;
        }
        String key = "";
        switch (this.alarmMode) {
            case 0: {
                key = "tile.witchery.scarecrow.player_whitelist";
                break;
            }
            case 1: {
                key = "tile.witchery.scarecrow.player_blacklist";
                break;
            }
            case 2: {
                key = "tile.witchery.scarecrow.all_whitelist";
                break;
            }
            case 3: {
                key = "tile.witchery.scarecrow.none_from_whitelist";
                break;
            }
            case 4: {
                key = "tile.witchery.scarecrow.one_absent_whitelist";
                break;
            }
            case 5: {
                key = "tile.witchery.scarecrow.disabled";
            }
        }
        player.sendMessage((ITextComponent)new TextComponentTranslation(key, new Object[]{text2}));
    }
}

